#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BloodUnitModification : BaseTest 
	{

		private BOL.BloodUnitModification _bumControl;
		private DataRow _drBUM;
		private Common.ProductModification _productModificationCode = Common.ProductModification.SplitAdult;
		private Common.ModifyUnitMethod _modificationMethod = Common.ModifyUnitMethod.Closed;
		private System.DateTime _modificationDateTime;
		private DataTable _dtBloodUnit;
	    private BOL.LockManager _myLockController = null;
        private int _lockedFormId = -262524;
        private int _baseLockedFormId = -262524;

		private DataTable _dtSplit;
		private System.Guid _splitGuid;
		private DataTable _dtThaw;
		private System.Guid _thawGuid;
		private DataTable _dtPool;

		//For our manmade pool --
		private BOL.BloodUnit _pooledUnitB;
		private BOL.BloodUnit _pooledUnitA;

		//To make sure we have enough of this bloomin data to test!!!  YARRRGH!
		private BOL.Supply _container = null;
		private BOL.Supply _scdWafer = null;
		private BOL.Supply _supply = null;
		private BOL.Supply _supply2 = null;
		private BOL.Equipment _equipment = null;
		private BOL.Equipment _equipment2 = null;

		private bool _doOnlyOnce = true;

		private decimal _splitCharge = decimal.Zero;
		private decimal _poolCharge = decimal.Zero;
		private decimal _thawCharge = decimal.Zero;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this._doOnlyOnce)
			{
				//WIPE THE TABLE CLEAN -- TO ensure day1 scenario is tested
				UnitTestUtil.RunSQL("DELETE FROM PoolCounter");
				this._doOnlyOnce = false;
			}

			if (this.RefreshData)
			{
				this.CreateSuppliesAndEquipment();

				_modificationDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

				System.Text.StringBuilder sb = new System.Text.StringBuilder();
				sb.Append(" SELECT TOP 1 *");
				sb.Append(" FROM BloodUnitModification");
				sb.Append(" WHERE " + TABLES.BloodUnitModification.ProductModificationCode + " = '" + Common.Utility.GetProductModificationCharFromEnum(this._productModificationCode) + "'");
				sb.Append(" AND " + TABLES.BloodUnitModification.DivisionCode + " = '" + UnitTestConfig.TestDivisionCode + "'");
				sb.Append(" AND " + TABLES.BloodUnitModification.RecordStatusCode + " = '" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active) + "'");
			
				DataTable dtSplit = UnitTestUtil.RunSQLGetDataTable(sb.ToString(), false);
				if (dtSplit.Rows.Count == 0)
				{
					BOL.BloodUnit tmpUnit = DataCreator.CreateModifiableBloodUnit(this._productModificationCode, this._modificationMethod, false);
					BOL.BloodUnitModification tmpMod = new BOL.BloodUnitModification(this._productModificationCode, this._modificationMethod, _modificationDateTime, Common.LogonUser.LogonUserName);
					tmpMod.SplitUnit(tmpUnit.BloodUnitGuid, 5);
					tmpMod.Save(Common.UpdateFunction.UnitTests);

					dtSplit = UnitTestUtil.RunSQLGetDataTable(sb.ToString(), true);
					_drBUM = dtSplit.Rows[0];
				}
				
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "' AND BloodUnitGuid NOT IN (SELECT ToBloodUnitGuid FROM BloodUnitModification)", true);
		
				DataCreator.CreateModifiableBloodUnit(COMMON.ProductModification.Pooled, COMMON.ModifyUnitMethod.Open, false);
				this._dtPool = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open,false);
				
				BOL.BloodUnit thawUnit = DataCreator.CreateModifiableBloodUnit(COMMON.ProductModification.Thawed, COMMON.ModifyUnitMethod.Closed, false);
				this._thawGuid = thawUnit.BloodUnitGuid;
				this._dtThaw = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed,false);
				
				BOL.BloodUnit splitUnit = DataCreator.CreateModifiableBloodUnit(COMMON.ProductModification.SplitAdult, COMMON.ModifyUnitMethod.Closed, false);
				this._splitGuid = splitUnit.BloodUnitGuid;
				this._dtSplit = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed,false);
				
				this.CreatePoolForTests(true, true);		//Create some floofy pool units
				this.RefreshData = false;

				//Create a non-divisible cost for full code coverage (cost calculation methods)
				UnitTestUtil.RunSQL("UPDATE ProductModificationParameter SET ProductModificationCost = 7.77 WHERE ProductModificationCode = 'S' AND DivisionCode = '" + this.TestDivisionCode + "'");
			}

			//Grab the charges each time, since we're updating for tests
			BOL.BloodProductModifications tmpBPM = new BOL.BloodProductModifications(this.TestDivisionCode);
			this._poolCharge = (decimal)tmpBPM.ModificationCosts[Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Pooled)];
			this._splitCharge = (decimal)tmpBPM.ModificationCosts[Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.SplitAdult)];
			this._thawCharge = (decimal)tmpBPM.ModificationCosts[Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Thawed)];

			this._bumControl = new BOL.BloodUnitModification(this._productModificationCode, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);

			DAL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, true);		//Modifing creates locks, so free them
		}

	    private BOL.LockManager MyLockController
	    {
            get
            {
                if (this._myLockController == null)
                {
                    this._myLockController = new LockManager(this._lockedFormId, this._baseLockedFormId,BOL.LockManager.DefaultLockInactivityTimeoutMin);
                    this._myLockController.LockFunction = Common.LockFunctions.UC024PoolUnits;
                }
                return (this._myLockController);
            }
	    }

	    [Test]
		public void Ctor_Pass()
		{
			BOL.BloodUnitModification testControl = new BOL.BloodUnitModification(this._productModificationCode, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);

			Assert.AreEqual(this._bumControl.ProductModificationCode, testControl.ProductModificationCode, "ProductModificationCode");
			Assert.AreEqual(this._bumControl.ModificationMethod, testControl.ModificationMethod, "ModificationMethod");
			Assert.AreEqual(this._bumControl.ModificationDateTime, testControl.ModificationDateTime, "ModificationDateTime");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void OriginalUnitVolume_Pass()
		{
			//-----Split Test
			System.Guid unitGuid = this._splitGuid;
			BOL.BloodUnit tstBU = new BOL.BloodUnit(unitGuid);
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(unitGuid, 2);

			Assert.AreEqual(tstBU.OriginalVolume, tstBUM.OriginalUnitVolume, "Split.OriginalVolume");

			//--------------------------------------
			unitGuid = this._thawGuid;
			tstBU = new BOL.BloodUnit(unitGuid);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.ModifyUnit(unitGuid);

			Assert.AreEqual(tstBU.OriginalVolume, tstBUM.OriginalUnitVolume, "Non-Split.OriginalVolume");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OriginalUnitVolume_Fail()
		{
		}

		[Test]
		public void InheritedPatientAssignment_Pass()
		{
			System.Guid[] tstValue = 
				{
					System.Guid.NewGuid(),
					System.Guid.NewGuid()
				};


			this._bumControl.InheritedPatientAssignment = tstValue;

			Assert.AreEqual(tstValue, this._bumControl.InheritedPatientAssignment);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InheritedPatientAssignment_Fail()
		{
		}

		[Test]
		public void DoPoolingUnitsHaveAssignedPatients_Pass()
		{
			BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)this._dtPool.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

			tstBUM.AddUnitToPool(tstBU);

			int tstValue = tstBU.AssignedToPatients.Count;
			bool retValue = tstBUM.DoPoolingUnitsHaveAssignedPatients;

			Assert.AreEqual(tstValue > 0, retValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DoPoolingUnitsHaveAssignedPatients_Fail()
		{
		}

		[Test]
		public void OriginalUnit_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			BOL.BloodUnit testUnit = new BOL.BloodUnit(this._thawGuid);

			tstBUM.ModifyUnit(testUnit.BloodUnitGuid);

			Assert.AreEqual(testUnit.BloodUnitGuid, tstBUM.OriginalUnit.BloodUnitGuid, "BloodUnitGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OriginalUnit_Fail()
		{
		}

		[Test]
		public void TargetCMVNeg_Pass()
		{
			Assert.AreEqual(true, this._bumControl.TargetCmvNeg);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TargetCMVNeg_Fail()
		{
		}

		[Test]
		public void UnitUsingOriginalContainer_Pass()
		{
			BOL.BloodUnitModification tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tmpBUM.SplitUnit(this._splitGuid, 2);

			//Closed defaults the container to the 1st split since half the gunk stays in that bag
			Assert.AreEqual(0, tmpBUM.UnitUsingOriginalContainer, "false");

			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tmpBUM.SplitUnit(this._splitGuid, 2);

			//Open sets no default
			Assert.AreEqual(int.MinValue, tmpBUM.UnitUsingOriginalContainer, "false");

			((BOL.ModifiedUnit)tmpBUM.SplitUnits[0]).OriginalContainerIndicator = true;
			Assert.AreEqual(0, tmpBUM.UnitUsingOriginalContainer, "true");

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitUsingOriginalContainer_Fail()
		{
		}

		[Test]
		public void ModifiedUnit_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			BOL.BloodUnit testUnit = new BOL.BloodUnit(this._thawGuid);

			tstBUM.ModifyUnit(testUnit.BloodUnitGuid);

			Assert.AreEqual(testUnit.BloodUnitGuid, tstBUM.ModifiedUnit.FromBloodUnitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ModifiedUnit_Fail()
		{
		}

		[Test]
		public void Exceptions_Pass()
		{
			System.Collections.ArrayList tstValue = new System.Collections.ArrayList();
			tstValue.Add(System.DateTime.Now);

			this._bumControl.Exceptions = tstValue;

			Assert.AreEqual(tstValue, this._bumControl.Exceptions);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Exceptions_Fail()
		{
		}

		[Test]
		public void LabelExceptions_Pass()
		{
			System.Collections.ArrayList tstValue = new System.Collections.ArrayList();
			tstValue.Add(System.DateTime.Now);

			this._bumControl.LabelExceptions = tstValue;

			Assert.AreEqual(tstValue, this._bumControl.LabelExceptions);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabelExceptions_Fail()
		{
		}

		[Test]
		public void NewContainerWeldIndicator_Pass()
		{
			//--------------------------Split--------------------------------------------
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(this._splitGuid, 2);
			tstBUM.NewContainerWeldIndicator = true;
			tstBUM.NewContainerWeldIndicator = false;		//Code Coverage
			tstBUM.NewContainerWeldIndicator = true;		//Code Coverage

			BOL.ModifiedUnit tstSplit1 = (BOL.ModifiedUnit)tstBUM.SplitUnits[0];
			BOL.ModifiedUnit tstSplit2 = (BOL.ModifiedUnit)tstBUM.SplitUnits[1];

			Assert.AreEqual(true, tstSplit1.WeldIndicator, "Weld-1");
			Assert.AreEqual(true, tstSplit2.WeldIndicator, "Weld-2");
			Assert.AreEqual(tstSplit1.RecommendedExpirationDateTime(tstBUM), tstSplit1.NewUnit.BloodUnitMedia.UnitExpirationDate, "ExpDate-1");
			Assert.AreEqual(tstSplit2.RecommendedExpirationDateTime(tstBUM), tstSplit2.NewUnit.BloodUnitMedia.UnitExpirationDate, "ExpDate-2");

			//--------------------------Pool--------------------------------------------
			this.CreatePoolForTests(true, true);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.AddUnitToPool(this._pooledUnitA);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				tstBUM.AddUnitToPool(tstBU);

				if (tstBUM.PoolingUnits.Count > 1)
					break;
			}
            tstBUM.PoolUnits(this.MyLockController);

			DAL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, true);
			tstBUM.NewContainerWeldIndicator = true;

			Assert.AreEqual(true, tstBUM.PooledUnit.WeldIndicator, "Weld");
			Assert.AreEqual(tstBUM.PooledUnit.RecommendedExpirationDateTime(tstBUM), tstBUM.PooledUnit.NewUnit.BloodUnitMedia.UnitExpirationDate, "ExpDate");

			//--------------------------Modify--------------------------------------------
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);

			tstBUM.ModifyUnit(this._thawGuid);
			tstBUM.NewContainerWeldIndicator = true;

			Assert.AreEqual(true, tstBUM.ModifiedUnit.WeldIndicator, "Weld");
			Assert.AreEqual(tstBUM.ModifiedUnit.RecommendedExpirationDateTime(tstBUM), tstBUM.ModifiedUnit.NewUnit.BloodUnitMedia.UnitExpirationDate, "ExpDate");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void NewContainerWeldIndicator_Fail()
		{
		}

		[Test]
		public void PoolingUnits_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)this._dtPool.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
			tstBUM.AddUnitToPool(tstBU);

			Assert.IsNotNull(tstBUM.PoolingUnits);
			Assert.AreEqual(tstBU.BloodUnitGuid, ((BOL.BloodUnit)tstBUM.PoolingUnits[0]).BloodUnitGuid, "Guid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PoolingUnits_Fail()
		{
		}

		[Test]
		public void PooledUnit_Pass()
		{
			this.CreatePoolForTests(true, true);
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.AddUnitToPool(this._pooledUnitA);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);
				tstBUM.AddUnitToPool(tstBU);

				if (tstBUM.PoolingUnits.Count > 1)
					break;
			}

			tstBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

			Assert.IsNotNull(tstBUM.PooledUnit);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PooledUnit_Fail()
		{
		}

		[Test]
		public void SplittingUnit_Pass()
		{
			BOL.BloodUnit tstBU = new BOL.BloodUnit(this._splitGuid);
			this._bumControl.SplitUnit(this._splitGuid, 2);

			Assert.AreEqual(this._bumControl.SplittingUnit.BloodUnitGuid, tstBU.BloodUnitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SplittingUnit_Fail()
		{
		}

		[Test]
		public void SplitUnits_Pass()
		{
			this._bumControl.SplitUnit(this._splitGuid, 2);
			Assert.AreEqual(2, this._bumControl.SplitUnits.Count, "Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SplitUnits_Fail()
		{
		}

		[Test]
		public void SplitCount_Pass()
		{
			this._bumControl.SplitUnit(this._splitGuid, 2);

			Assert.AreEqual(2, this._bumControl.SplitCount);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SplitCount_Fail()
		{
		}

		[Test]
		public void MinimumPooledUnitsAllowed_Pass()
		{
			Assert.AreEqual(2, this._bumControl.MinimumPooledUnitsAllowed);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MinimumPooledUnitsAllowed_Fail()
		{
		}

		[Test]
		public void MaximumSplitUnitsAllowed_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			tstBUM.SplitUnit(unitGuid, 2);

			tstBUM.SplittingUnit.OriginalVolume = 25;
			Assert.AreEqual(25, tstBUM.MaximumSplitUnitsAllowed, "Volume<26");

			tstBUM.SplittingUnit.OriginalVolume = 27;
			Assert.AreEqual(26, tstBUM.MaximumSplitUnitsAllowed, "Volume>26");
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void MaximumSplitUnitsAllowed_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			tstBUM.SplitUnit(unitGuid, 2);

			tstBUM.SplittingUnit.OriginalVolume = 1;

			int tstValue = tstBUM.MaximumSplitUnitsAllowed;
		}

		[Test]
		public void DefaultSplitUnits_Pass()
		{
			Assert.AreEqual(2, BOL.BloodUnitModification.DefaultSplitUnits);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DefaultSplitUnits_Fail()
		{
		}

		[Test]
		public void MaximumModificationDateTime_Pass()
		{
			System.DateTime tstValue = BOL.BloodUnitModification.MaximumModificationDateTime;

			Assert.AreEqual(true, tstValue <= BOL.VBECSDateTime.GetDivisionCurrentDateTime());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MaximumModificationDateTime_Fail()
		{
		}

		[Test]
		public void ProductModificationCode_Pass()
		{
			Common.ProductModification tstValue = this._bumControl.ProductModificationCode;

			Assert.AreEqual(tstValue, this._bumControl.ProductModificationCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ProductModificationCode_Fail()
		{
		}

		
		[Test]
		public void ProductModificationCodeBase_Pass()
		{
			Common.ProductModification tstValue = this._bumControl.ProductModificationCodeBase;

			Assert.AreEqual(this._bumControl.ProductModificationCodeBase, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ProductModificationCodeBase_Fail()
		{
		}

		[Test]
		public void ModificationMethod_Pass()
		{
			Common.ModifyUnitMethod tstValue = this._bumControl.ModificationMethod;

			Assert.AreEqual(tstValue, this._bumControl.ModificationMethod);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ModificationMethod_Fail()
		{
		}

		[Test]
		public void ModificationDateTime_Pass()
		{
			System.DateTime tstValue = this._bumControl.ModificationDateTime;

			Assert.AreEqual(tstValue, this._bumControl.ModificationDateTime);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ModificationDateTime_Fail()
		{
		}

		[Test]
		public void ModificationTechID_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();
			
			this._bumControl.ModificationTechId = tmpValue;

			Assert.AreEqual(tmpValue, this._bumControl.ModificationTechId);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void ModificationTechID_Fail()
		{
			this._bumControl.ModificationTechId = string.Empty;
		}
		
		[Test]
		public void InactivatePoolCounter_Pass()
		{
			System.Guid tmpGuid = System.Guid.NewGuid();
			System.Guid poolGuid = this.CreatePoolForTests(true, true);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

			//This method should return true before we even have a pool to monkey with
			Assert.AreEqual(true, tstBUM.InactivatePoolCounter(), "DefaultValue");

			//Continue adding units
			tstBUM.AddUnitToPool(this._pooledUnitA);
			tstBUM.AddUnitToPool(this._pooledUnitB);

			if (tstBUM.PoolingUnits.Count < 2)
				Assert.IsTrue(false, "Powerful weak!  Pool not created.");

			tstBUM.PoolUnits(this.MyLockController);

			bool retValue = tstBUM.InactivatePoolCounter();

			Assert.AreEqual(true, retValue, "ReturnValue");

			//Cleanup the locks we may have created
			DAL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivatePoolCounter_Fail()
		{
		}

		[Test]
		public void GetNewPoolId_Pass()
		{
			for(int ndx=0; ndx < 2; ndx++)			//Do once for isbt and once for codabar
			{
				bool isCodabar = (ndx==0);
				//Create the pool to work with ------
				System.Guid lockGuid = System.Guid.NewGuid();
				this.CreatePoolForTests(true, isCodabar);

				BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

				tstBUM.AddUnitToPool(this._pooledUnitA);
				tstBUM.AddUnitToPool(this._pooledUnitB);

				if (tstBUM.PoolingUnits.Count < 2)
					Assert.IsTrue(false, "Powerful weak!  Pool not created.");

				tstBUM.PoolUnits(this.MyLockController);
                this.MyLockController.UnlockRecords();
				//--------------------------------------------------------
				string tstValue = tstBUM.GetNewPoolId(this.MyLockController);
				//Free the lock, so we can validate the value that was returned
                this.MyLockController.UnlockRecords();
				//Check the poolcounter table -- yadda yadda
				string ctrYear = System.DateTime.Now.ToString("yy");
				int ctrValue = 0;

				DataTable dtPoolCounterX = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM PoolCounter WHERE CounterYear = '" + ctrYear + "' AND DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'X' ORDER BY CounterValue DESC", false);
				DataTable dtPoolCounterA = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM PoolCounter WHERE CounterYear = '" + ctrYear + "' AND DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A' AND PoolCounterGuid NOT IN (SELECT LockedRecordGuid FROM VbecsLock) ORDER BY CounterValue", false);

				if (dtPoolCounterA.Rows.Count == 0)	//No rows were found, so the next number will be given to us
				{
					if (dtPoolCounterX.Rows.Count > 0)
						ctrValue = System.Convert.ToInt16(dtPoolCounterX.Rows[0][TABLES.PoolCounter.CounterValue]);

					ctrValue++;
				}
				else
				{
					ctrValue = System.Convert.ToInt16(dtPoolCounterA.Rows[0][TABLES.PoolCounter.CounterValue]);
				}

				string myValue = string.Empty;

				//Validate the data
				switch (tstBUM.PooledUnit.NewUnit.BarcodeType)
				{
					case Common.BarcodeType.Codabar:
				
						myValue = this.TestDivisionCode.Replace(" ", "0") + ctrYear + ctrValue.ToString();
						Assert.AreEqual(tstValue, myValue, "Codabar");
						break;

					case Common.BarcodeType.ISBT128:

						BOL.Division div = new BOL.Division(this.TestDivisionCode);
						myValue = div.IccbbaRegistrationNumber + ctrYear + ctrValue.ToString("000000");
						break;
				}

                this.MyLockController.UnlockRecords();
			}
		}
					
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetNewPoolId_Fail()
		{
		}

		[Test]
		public void EditPool_Pass()
		{
			System.Guid poolGuid = this.CreatePoolForTests(false, true);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid);

			Assert.AreEqual(2, tstBUM.PoolingUnits.Count, "PooledUnits.Count");
			Assert.AreEqual(poolGuid, tstBUM.PooledUnit.NewUnit.BloodUnitGuid, "PooledUnit.Guid");
		}

		[Test]
		[ExpectedException(typeof(IndexOutOfRangeException))]
		public void EditPool_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(System.Guid.NewGuid());
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			Assert.IsNull(this._bumControl.LoadDataRowFromThis(this._dtSplit.NewRow()));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


		[Test]
		public void SplitAgain_Pass()
		{
			string temp = string.Empty;
			string orig = string.Empty;
			BOL.BloodUnitModification tstBUM_I = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			BOL.BloodUnitModification tstBUM_C = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

			System.Guid unitGuid = this._splitGuid;

			//Process an ISBT unit first
			foreach(DataRow dr in this._dtSplit.Rows)
			{
				if (dr[TABLES.BloodUnit.LabelTypeCode].ToString() == Common.Utility.GetBarcodeTypeCodeCharFromEnum(Common.BarcodeType.ISBT128).ToString())
				{
					tstBUM_I.SplitUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid], 2);
					//Setting costs to ensure unitCost is split
					tstBUM_I.SplittingUnit.BloodUnitFinance.UnitCost = 333;

					//Broken Rules need to be set, or else code fails
					tstBUM_I.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName, string.Empty);

					Assert.AreEqual(2, tstBUM_I.SplitCount, "IBST-SplitCount-2");

					tstBUM_I.SplitAgain(5);
					Assert.AreEqual(5, tstBUM_I.SplitCount, "IBST-SplitCount-5");

					//Test the Same Number -- Code Coverage
					tstBUM_I.SplitAgain(5);
					Assert.AreEqual(5, tstBUM_I.SplitCount, "IBST-SplitCount-5-Check");

					tstBUM_I.SplitAgain(3);
					Assert.AreEqual(3, tstBUM_I.SplitCount, "IBST-SplitCount-3");

					//Calculate the charge of the final unit
					decimal targetCost = decimal.Zero;
					targetCost = (decimal)111 + this.GetModificationCost(Common.ProductModification.SplitAdult, tstBUM_I.SplitCount, this._splitCharge);

					//Validate the new EyeReadables
					temp = ((BOL.ModifiedUnit)tstBUM_I.SplitUnits[0]).NewUnit.UnitDivisionId;
					Assert.AreEqual("A0", temp , "IBST-DivisionId-1");
					Assert.AreEqual(targetCost, ((BOL.ModifiedUnit)tstBUM_I.SplitUnits[0]).NewUnit.BloodUnitFinance.UnitCost, "UnitCost");
					
					temp = ((BOL.ModifiedUnit)tstBUM_I.SplitUnits[1]).NewUnit.UnitDivisionId;
					Assert.AreEqual("B0", temp , "IBST-DivisionId-2");

					temp = ((BOL.ModifiedUnit)tstBUM_I.SplitUnits[2]).NewUnit.UnitDivisionId;
					Assert.AreEqual("C0", temp , "IBST-DivisionId-3");
					
					break;
				}
			}

			//Process a Codabar unit 
			foreach(DataRow dr in this._dtSplit.Rows)
			{
				if (dr[TABLES.BloodUnit.LabelTypeCode].ToString() == Common.Utility.GetBarcodeTypeCodeCharFromEnum(Common.BarcodeType.Codabar).ToString())
				{
					orig = dr[TABLES.BloodUnit.EyeReadableUnitId].ToString();

					tstBUM_C.SplitUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid], 2);
					//Broken Rules need to be set, or else code fails -- this seems bad. I blame Lohse!
					tstBUM_C.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName, string.Empty);
					Assert.AreEqual(2, tstBUM_C.SplitCount, "Codabar-SplitCount-2");

					tstBUM_C.SplitAgain(5);
					Assert.AreEqual(5, tstBUM_C.SplitCount, "Codabar-SplitCount-5");

					tstBUM_C.SplitAgain(3);
					Assert.AreEqual(3, tstBUM_C.SplitCount, "Codabar-SplitCount-3");

					//Validate the new EyeReadables
					temp = ((BOL.ModifiedUnit)tstBUM_C.SplitUnits[0]).NewUnit.EyeReadableUnitId;
					Assert.AreEqual(orig+"A", temp , "Codabar-UnitId-1");
					
					temp = ((BOL.ModifiedUnit)tstBUM_C.SplitUnits[1]).NewUnit.EyeReadableUnitId;
					Assert.AreEqual(orig+"B", temp , "Codabar-UnitId-2");

					temp = ((BOL.ModifiedUnit)tstBUM_C.SplitUnits[2]).NewUnit.EyeReadableUnitId;
					Assert.AreEqual(orig+"C", temp , "Codabar-UnitId-3");
					
					break;
				}
			}
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void SplitAgain_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			tstBUM.SplitUnit(unitGuid, 2);

			tstBUM.SplitAgain(tstBUM.MaximumSplitUnitsAllowed + 1);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Split_UnitAlreadySplit_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			BOL.BloodUnit tmpUnit = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, false);

			tstBUM.SplitUnit(tmpUnit.BloodUnitGuid, 2);
			tstBUM.Save(Common.UpdateFunction.UnitTests);

			//OK, we created a split, now lets try to split it again.
			System.Guid splitGuid = ((BOL.ModifiedUnit) tstBUM.SplitUnits[0]).ToBloodUnitGuid;
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(splitGuid, 2);
		}

		[Test]
		public void SetOriginalContainerIndicator_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			tstBUM.SplitUnit(unitGuid, 2);
			tstBUM.SetOriginalContainerIndicator(0,true);

			BOL.ModifiedUnit tstValue1 = (BOL.ModifiedUnit)tstBUM.SplitUnits[0];
			BOL.ModifiedUnit tstValue2 = (BOL.ModifiedUnit)tstBUM.SplitUnits[1];

			Assert.AreEqual(true, tstValue1.OriginalContainerIndicator, "True-");
			Assert.AreEqual(false, tstValue2.OriginalContainerIndicator, "False-");

			tstBUM.SetOriginalContainerIndicator(0, false);
			Assert.AreEqual(false, tstValue1.OriginalContainerIndicator, "Setting with False");

		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void SetOriginalContainerIndicator_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			tstBUM.SplitUnit(unitGuid, 2);

			tstBUM.SetOriginalContainerIndicator(3,true);
		}

		[Test]
		public void SetInitialBrokenRules_String_String_Pass()
		{
			//Create some VolumeReducable units...
			DataCreator.CreateModifiableBloodUnit(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Open, false);
			DataCreator.CreateModifiableBloodUnit(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Closed, false);
			DataCreator.CreateModifiableBloodUnit(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Open, true);
			DataCreator.CreateModifiableBloodUnit(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Closed, true);

			//Testing BrokenRules for VolumeReduce(Open)
			DataTable dtModify = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Open,false);
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = (System.Guid)dtModify.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			tstBUM.ModifyUnit(unitGuid);
			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName, string.Empty);
			Assert.AreEqual(true, tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName).Length >= 0, "BrokenRules-Open");

			//Testing BrokenRules for Thaw(Closed)
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			unitGuid = this._thawGuid;
			tstBUM.ModifyUnit(unitGuid);
			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName, string.Empty);
			Assert.AreEqual(true, tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName).Length >= 0, "BrokenRules-Closed");

			//Testing BrokenRules for VolumeReduce(SCD)
			dtModify = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.SterileConnectingDevice,false);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.SterileConnectingDevice, System.DateTime.Now, Common.LogonUser.LogonUserName);
			unitGuid = (System.Guid)dtModify.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			tstBUM.ModifyUnit(unitGuid);
			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName, string.Empty);
			Assert.AreEqual(true, tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName).Length >= 0, "BrokenRules-SCD");

			//Testing BrokenRules for Split
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			unitGuid = this._splitGuid;
			tstBUM.SplitUnit(unitGuid, 2);
			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName, string.Empty);
			Assert.AreEqual(true, tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName).Length >= 0, "BrokenRules-Split");

			//Testing BrokenRules for EditPool
			unitGuid = this.CreatePoolForTests(false, true);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(unitGuid);
			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmPoolUnits.FormClassName, string.Empty);
			Assert.AreEqual(true, tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmPoolUnits.FormClassName).Length >= 0, "BrokenRules-EditPool");

			//Testing BrokenRules for Pool
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.AddUnitToPool(this._pooledUnitA);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (errors.Count == 0)
				{
					tstBUM.AddUnitToPool(tstBU);
					if (tstBUM.PoolingUnits.Count > 1)
						break;
				}
			}
			tstBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmPoolUnits.FormClassName, string.Empty);
			Assert.AreEqual(true, tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmPoolUnits.FormClassName).Length >= 0, "BrokenRules-Pool");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SetInitialBrokenRules_String_String_Fail()
		{
		}

		[Test]
		public void GetBrokenRulesMessage_Pass()
		{
			//Get messages for split..
			BOL.BloodUnitModification bumSplit = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;
			bumSplit.SplitUnit(unitGuid, 2);

			bumSplit.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName, string.Empty);
			string tstValue = bumSplit.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName);
			Assert.IsNotNull(tstValue, "Split");

			//Get messages for pooled..
			System.Guid poolGuid = this.CreatePoolForTests(false, true);
			BOL.BloodUnitModification bumPool = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			bumPool.EditPool(poolGuid);

			bumPool.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmPoolUnits.FormClassName, string.Empty);
			tstValue = bumPool.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmPoolUnits.FormClassName);
			Assert.IsNotNull(tstValue, "Pool");

			//Get messages for all other modifys..
			BOL.BloodUnitModification bumThaw = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid thawGuid = this._thawGuid;
			bumThaw.ModifyUnit(thawGuid);

			bumThaw.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName, string.Empty);
			tstValue = bumThaw.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName);

			Assert.IsNotNull(tstValue, "Modify");
		}

		[Test]
		public void GetBrokenRulesMessage_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			tstBUM.SplitUnit(unitGuid, 2);

			tstBUM.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmSplitUnit.FormClassName, "Default");

			string tstValue = tstBUM.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmShipmentIn.FormClassName);

			Assert.AreEqual(string.Empty, tstValue);
		}

		[Test]
		public void SplitUnit_Pass()
		{
			this.RefreshData = true;

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._splitGuid;

			//Make sure the BloodUnitFinance table has costs
			UnitTestUtil.RunSQL("UPDATE BloodUnitFinance SET UnitCost = 7.77, SpecialTestingCost = 7.77 WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			tstBUM.SplitUnit(unitGuid, 2);

			Assert.AreEqual(2, tstBUM.SplitCount);
			BOL.ModifiedUnit tmpSU = (BOL.ModifiedUnit)tstBUM.SplitUnits[0];
			
			Assert.AreEqual((decimal)(3.89), (decimal)tmpSU.NewUnit.BloodUnitFinance.SpecialTestingCost, "Costs");

			//CR2576 - Create a Unit as if it was logged in via UC1
			BOL.BloodUnit tmpUC1Split = DataCreator.CreateBloodUnit(false);
			UnitTestUtil.RunSQL("UPDATE BloodUnit SET UnitDivisionId = 'A0' WHERE BloodUnitGuid = '" + tmpUC1Split.BloodUnitGuid.ToString() + "'");
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(tmpUC1Split.BloodUnitGuid,3);
			string tstValue = ((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).NewUnit.UnitDivisionId;
			Assert.AreEqual("Ab", tstValue , "IBST-DivisionId-UC1Split");

		}

		[Test]
		public void SplitUnit_Fail()
		{
			try
			{
				BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
				System.Guid unitGuid = System.Guid.NewGuid();
				tstBUM.SplitUnit(unitGuid, 2);
				Assert.False(false, "Invalid Unit split should have raised Exception");
			}
			catch(BOL.BusinessObjectException)
			{
				Assert.True(true);
			}

			try
			{
				//CR2576 -- Split a unit that was already split 
				BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
				System.Guid tmpUC25Split = DataCreator.GetRecordGuid("SELECT TOP 1 BU.BloodUnitGuid FROM BloodUnit BU JOIN BloodUnitModification BUM ON BU.BloodUnitGuid = BUM.ToBloodUnitGuid AND BU.UnitDivisionId = 'A0'");
				tstBUM.SplitUnit(tmpUC25Split,3);
				Assert.False(false, "Existing Split split should have raised Exception");
			}
			catch(BOL.BusinessObjectException)
			{
				Assert.True(true);
			}

			BOL.BloodUnit tmpUC1Split = DataCreator.CreateBloodUnit(false);
			try
			{
				//CR2576 - Create a Unit as if it was logged in via UC1
				UnitTestUtil.RunSQL("UPDATE BloodUnit SET UnitDivisionId = '10' WHERE BloodUnitGuid = '" + tmpUC1Split.BloodUnitGuid.ToString() + "'");
				BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
				tstBUM.SplitUnit(tmpUC1Split.BloodUnitGuid,3);
				Assert.False(false, "Invalid UnitDivisionId should have raised Exception");
			}
			catch(BOL.BusinessObjectException)
			{
				UnitTestUtil.RunSQL("UPDATE BloodUnit SET UnitDivisionId = '00' WHERE BloodUnitGuid = '" + tmpUC1Split.BloodUnitGuid.ToString() + "'");
				Assert.True(true);
			}
		}

		
		[Test]
		public void ValidateAddingPoolUnit_Pass()
		{
			this.RefreshData = true;

			this.CreatePoolForTests(true, true);
			System.Collections.ArrayList tstValue = new System.Collections.ArrayList();

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstValue = tstBUM.ValidateAddingPoolUnit(this._pooledUnitA);
			Assert.AreEqual(0, tstValue.Count, "First Pooly" );
			tstBUM.AddUnitToPool(this._pooledUnitA);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				if (tstBUM.PoolingUnits.Count > 0)
					tstValue = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (tstValue.Count == 0)
					tstBUM.AddUnitToPool(tstBU);

				if (tstBUM.PoolingUnits.Count > 2)
					break;
			}
			Assert.AreEqual(0, tstValue.Count, "Pool" );


			//*****************************************************************************
			//Test method for Editing a Pool
			//*****************************************************************************
			System.Guid poolGuid = this.CreatePoolForTests(false, true);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid);

			int prevCount = tstBUM.PoolingUnits.Count;
			bool didOnce = false;

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				if (!didOnce)	//This is to test that a new unit won't disrupt the existing Target Product -- code coverage
				{
					tstBU.BloodProductGuid = System.Guid.NewGuid();
					didOnce = true;
				}
				
				tstValue = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (tstValue.Count == 0)		//Add the unit for code coverage
				{
					tstBUM.AddUnitToPool(tstBU);
					break;
				}
			}

			Assert.AreEqual(0, 0, "EditPool");		//Editing Pool is too complicated to code
		}


		[Test]
		public void ValidateAddingPoolUnit_Fail()
		{
			this.RefreshData = true;

			bool tstValue = false;

			this.CreatePoolForTests(true, true);

			System.Collections.ArrayList tstRC = new System.Collections.ArrayList();
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			BOL.BloodUnit firstUnit = this._pooledUnitA;
			BOL.BloodUnit secondUnit = null;

			tstBUM.AddUnitToPool(firstUnit);

			//Get our first Unit
			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				tstRC = tstBUM.ValidateAddingPoolUnit(tstBU);

				//Get our first unit, and a 2nd unit to tinker with to validate all the business rules
				if (tstRC.Count == 0 && tstBU.EyeReadableUnitId != firstUnit.EyeReadableUnitId)
				{
					secondUnit = tstBU;
					break;
				}
			}
			
			if (secondUnit == null)  Assert.IsTrue(false, "No Valid Units to Pool");

			//This will validate the we can't add the same unit twice
			tstRC = tstBUM.ValidateAddingPoolUnit(firstUnit);
			Assert.AreEqual(0, tstRC.Count, "Add same unit twice");

			//Can't add a unit that has been split to a pool
			BOL.BloodUnit splittingUnit = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, true);
			BOL.BloodUnitModification createSplit = new BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			createSplit.SplitUnit(splittingUnit.BloodUnitGuid, 2);
			createSplit.Save(Common.UpdateFunction.UnitTests);
			System.Guid splitGuid = ((BOL.ModifiedUnit)createSplit.SplitUnits[0]).ToBloodUnitGuid;
			BOL.BloodUnit splitUnit = new BOL.BloodUnit(splitGuid);
			tstRC = tstBUM.ValidateAddingPoolUnit(splitUnit);
			Assert.AreEqual(1, tstRC.Count, "Adding a split unit");

			//-------------------------------------------------------------------------
			//FROM HERE ON........BR VALIDATIONS FOUND IN BOL.BloodUnitModification.ValidatePoolRules() method
			//-------------------------------------------------------------------------

			//Can't add a unit that is a different component class
			tstValue = false;
			BOL.BloodUnit testUnit = new BOL.BloodUnit(secondUnit.BloodUnitGuid);
			testUnit.BloodComponentClassId = (int)Common.ComponentClass.RBC;	//Can't POOL RBC
			tstRC = tstBUM.ValidateAddingPoolUnit(testUnit);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC024.BR02ComponentType(testUnit.EyeReadableUnitId, testUnit.ProductType.ProductTypeText, firstUnit.BloodComponentName).ResString)
				{	tstValue = true;	}
			}
			Assert.AreEqual(true, tstValue, "BR_24.02");

			//Can't add a unit with a different donation type
			string directedTypeText = "Allogeneic";
			if (firstUnit.DonationType.DirectedType == "D")	directedTypeText = "Directed";
			if (firstUnit.DonationType.DirectedType == "A")	directedTypeText = "Autologous";

			tstValue = false;
			testUnit = new BOL.BloodUnit(secondUnit.BloodUnitGuid);
			testUnit.DonationType.DirectedType = "X";
			tstRC = tstBUM.ValidateAddingPoolUnit(testUnit);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC024.BR15DonationType(testUnit.EyeReadableUnitId, testUnit.ProductType.ProductTypeText, directedTypeText).ResString)
				{	tstValue = true;	}
			}
			Assert.AreEqual(true, tstValue, "BR_24.15");

			//Can't add a unit with a different directed patient
			tstValue = false;
			testUnit = new BOL.BloodUnit(secondUnit.BloodUnitGuid);
			testUnit.BloodUnitMedia.DirectedPatientGuid = System.Guid.NewGuid();
			tstRC = tstBUM.ValidateAddingPoolUnit(testUnit);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC024.BR16DifferentPatient(testUnit.EyeReadableUnitId, testUnit.ProductType.ProductTypeText).ResString)
				{	tstValue = true;	}
			}
			Assert.AreEqual(true, tstValue, "BR_24.16");

			//BR24.17 - can't be tested, BR24.15 is a similiar rule, and will kickout the unit before 
			//the logic will hit BR24.17


			//////////////////////////////////////////////////////////////////////////////
			//-----------Validate the EditPool Rules-------------------------------------
			//////////////////////////////////////////////////////////////////////////////
			this.CreatePoolForTests(true, true);
			System.Guid poolGuid = this.CreatePoolForTests(false, true);

			//Get our latest created units
			this._dtPool = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open,false);

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid);

			BOL.BloodUnit tmpExisting = (BOL.BloodUnit)tstBUM.PoolingUnits[0];
			System.Guid testUnitGuid;
			BOL.BloodUnit tmpUnit = null;
			bool unitFound = false;

			foreach(DataRow drUnit in this._dtPool.Rows)
			{
				testUnitGuid = (System.Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid];
				tmpUnit = new BOL.BloodUnit(testUnitGuid);

				if (tmpUnit.BloodProductGuid == tmpExisting.BloodProductGuid)
				{
					if (tmpUnit.DonationType.DonationTypeCode == tmpExisting.DonationType.DonationTypeCode)
					{
						//If the unit we're adding was valid, then we'll know the rest of the test conditions should be
						//valid to test with as well... aka, we're not frying a bad chicken in dirty oil
						tstRC = tstBUM.ValidateAddingPoolUnit(tmpUnit);
						if (tstRC.Count == 0)
						{
							unitFound = true;
							break;
						}
					}
				}
			}
			
			if (!unitFound) Assert.IsTrue(false, "Could not find 3rd unit to add to existing pool");

			//Unit shouldn't be added because it's expiration date is invalid
			tstValue = false;
			tmpUnit.BloodUnitMedia.UnitExpirationDate = tstBUM.PooledUnit.UnitExpirationDate.AddHours(-1);
			tstRC = tstBUM.ValidateAddingPoolUnit(tmpUnit);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC024.BR25ExpirationDate().ResString)
				{	tstValue = true;	}
			}
			Assert.AreEqual(true, tstValue, "BR_24.25 - Unit < Pool.ExpirationDate");
			tmpUnit.BloodUnitMedia.UnitExpirationDate = tstBUM.PooledUnit.UnitExpirationDate.AddDays(1);

			//Test to make sure the donation types match
			tstValue = false;
			System.Guid badBPGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE ProductCode = 'E2820'");
			System.Guid badBUGuid = System.Guid.NewGuid();
			DataCreator.CreateBloodUnit(badBUGuid, System.Guid.NewGuid(), System.Guid.Empty, badBPGuid, false);
			
			BOL.BloodUnit badUnit = new BOL.BloodUnit(badBUGuid);
			tstRC = tstBUM.ValidateAddingPoolUnit(badUnit);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC024.BR28AddingUnitWillChangeTarget(badUnit.EyeReadableUnitId, badUnit.ProductType.ProductTypeText).ResString)
				{	tstValue = true;	}
			}
			Assert.AreEqual(true, tstValue, "BR_24.28");		//24_15 catches the other half of BR24.28

			//Unit shouldn't be added because it's expiration date is prior to original pools creation date
			tstValue = false;
			tmpUnit.DonationType = tstBUM.PooledUnit.NewUnit.DonationType;
			tmpUnit.BloodUnitMedia.UnitExpirationDate = tstBUM.PooledUnit.NewUnit.UnitInDate.AddHours(-1);
			tstRC = tstBUM.ValidateAddingPoolUnit(tmpUnit);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC024.BR25ExpirationDate().ResString)
				{	tstValue = true;	}
			}
			Assert.AreEqual(true, tstValue, "BR_24.25 - Unit < Pool.UnitInDate");
		}
		
		[Test]
		public void GetTargetBloodProducts_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.SterileConnectingDevice, this._modificationDateTime, Common.LogonUser.LogonUserName);
			DataTable dtSCDOpen = tstBUM.GetTargetBloodProducts(this._dtSplit.Rows[0][TABLES.BloodUnit.BloodProductGuid].ToString());
			Assert.AreEqual(true, dtSCDOpen.Rows.Count > 0, "Rows.Count-SCDOpen");

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.SterileConnectingDevice, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstBUM.NewContainerWeldIndicator = true;
			DataTable  dtSCDClosed = tstBUM.GetTargetBloodProducts(this._dtSplit.Rows[0][TABLES.BloodUnit.BloodProductGuid].ToString());
			Assert.AreEqual(true, dtSCDClosed.Rows.Count > 0, "Rows.Count-Closed");

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
			DataTable  dtOpen = tstBUM.GetTargetBloodProducts(this._dtSplit.Rows[0][TABLES.BloodUnit.BloodProductGuid].ToString());
			Assert.AreEqual(true, dtOpen.Rows.Count > 0, "Rows.Count-Open");

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			DataTable  dtClosed= tstBUM.GetTargetBloodProducts(this._dtSplit.Rows[0][TABLES.BloodUnit.BloodProductGuid].ToString());
			Assert.AreEqual(true, dtClosed.Rows.Count > 0, "Rows.Count-Closed");

			Assert.AreEqual(dtOpen.Rows.Count, dtSCDOpen.Rows.Count, "SCDOpen = Open");
			Assert.AreEqual(dtClosed.Rows.Count, dtSCDClosed.Rows.Count, "SCDClosed = Close");
		}

		[Test]
		public void GetTargetBloodProducts_Fail()
		{
			DataTable dt = this._bumControl.GetTargetBloodProducts(System.Guid.NewGuid().ToString());

			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}


		[Test]
		public void AddUnitToPool_Pass()
		{
			this.CreatePoolForTests(true, true);
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.AddUnitToPool(this._pooledUnitA);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				tstBUM.AddUnitToPool(tstBU);

				//Doublecheck that we can't add the same unit twice
				if (tstBUM.PoolingUnits.Count == 1)
				{
					tstBUM.AddUnitToPool(tstBU);
					Assert.AreEqual(1, tstBUM.PoolingUnits.Count, "Cant add same unit twice");
				}

				if (tstBUM.PoolingUnits.Count > 1)
					break;
			}

			Assert.AreEqual(2, tstBUM.PoolingUnits.Count);

			System.Guid poolGuid = this.CreatePoolForTests(false, true);
			BOL.BloodUnitModification tstBUMEdit = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUMEdit.EditPool(poolGuid);
			
			int previousCtr = tstBUMEdit.PoolingUnits.Count;
			//We shouldn't be able to add itself
			tstBUMEdit.AddUnitToPool(this._pooledUnitA);
			Assert.AreEqual(previousCtr, tstBUMEdit.PoolingUnits.Count, "Can't add original unit twice");

			//Add a new unit, so we can remove an original
			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit addUnit = new BOL.BloodUnit(dr);
				tstBUMEdit.AddUnitToPool(addUnit);

				if(tstBUMEdit.PoolingUnits.Count > previousCtr)
					break;
			}

			//Remove an original
			tstBUMEdit.RemoveUnitFromPool(this._pooledUnitB.BloodUnitGuid);
			tstBUMEdit.AddUnitToPool(this._pooledUnitB);
			Assert.AreEqual(previousCtr+1, tstBUMEdit.PoolingUnits.Count, "Original Unit Removed and Re-Added");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddUnitToPool_Fail()
		{
		}

				
		[Test]
		public void IsOriginalUnit_Pass()
		{
			System.Guid poolGuid = this.CreatePoolForTests(false, true);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid);

			Assert.AreEqual(true, tstBUM.IsOriginalUnit(this._pooledUnitA.BloodUnitGuid));
		}

		[Test]
		public void IsOriginalUnit_Fail()
		{
			System.Guid poolGuid = this.CreatePoolForTests(false, true);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid);

			Assert.AreEqual(false, tstBUM.IsOriginalUnit(System.Guid.NewGuid()));
		}
				
		[Test]
		public void RemoveUnitFromPool_Pass()
		{
			System.Guid poolGuid = this.CreatePoolForTests(false, true);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

			tstBUM.EditPool(poolGuid);

			System.Guid unitGuid = ((BOL.BloodUnit)tstBUM.PoolingUnits[0]).BloodUnitGuid;

			int preCount = tstBUM.PoolingUnits.Count;

			tstBUM.RemoveUnitFromPool(unitGuid);

			Assert.AreEqual(preCount - 1, tstBUM.PoolingUnits.Count);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void RemoveUnitFromPool_Fail()
		{
			System.Guid poolGuid = this.CreatePoolForTests(false, true);
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

			tstBUM.EditPool(poolGuid);

			System.Collections.ArrayList guidArray = new System.Collections.ArrayList();
			foreach(BOL.BloodUnit bunit in tstBUM.PoolingUnits)
			{
				guidArray.Add(bunit.BloodUnitGuid);
			}

			foreach(System.Guid yoinkGuid in guidArray)
			{
				tstBUM.RemoveUnitFromPool(yoinkGuid);
			}
		}
				
		[Test]
		public void PoolUnits_Pass()
		{
			this.CreatePoolForTests(true, true);

			//run through first for a codabar pool
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			BOL.BloodUnit firstUnit = this._pooledUnitA;
			BOL.BloodUnit secondUnit = null;
			System.DateTime currentDate = System.DateTime.Now;

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (errors.Count == 0 && tstBU.EyeReadableUnitId != this._pooledUnitA.EyeReadableUnitId)
				{
					secondUnit = tstBU;
					break;
				}
			}

			//Testing BOL.BloodUnitModification.CalculatePooledProperties() ----------------------------
			firstUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.A;
			firstUnit.BloodUnitMedia.AboRh.RH = Common.RH.Negative;
			firstUnit.BloodUnitFinance.UnitCost = (decimal)420;
			firstUnit.OriginalVolume = (decimal)420;
			firstUnit.BloodUnitMedia.UnitExpirationDate = currentDate.AddYears(-1);

			secondUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.A;
			secondUnit.BloodUnitMedia.AboRh.RH = Common.RH.Negative;
			secondUnit.BloodUnitFinance.UnitCost = (decimal)420;
			secondUnit.OriginalVolume = (decimal)420;
			secondUnit.BloodUnitMedia.UnitExpirationDate = currentDate;

			tstBUM.AddUnitToPool(firstUnit);
			//Change the CMV Neg on 2nd unit to test that the pooling is still allowed
			DataTable dtCMVTest = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), secondUnit.BloodUnitGuid, (int)Common.TestType.CMV, "N");
			int rcCMV = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertBloodUnitTest.StoredProcName, dtCMVTest);
			Assert.AreEqual(0, rcCMV, "CMV Update");
			tstBUM.AddUnitToPool(secondUnit);

			tstBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

			//Calculate the charge of the final unit
			decimal targetCost = decimal.Zero;
			targetCost = (decimal)840 + this.GetModificationCost(Common.ProductModification.Pooled, 1, this._poolCharge);

			Assert.AreEqual(Common.ABO.A, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.Abo, "Codabar - ABO - Same");
			Assert.AreEqual(Common.RH.Negative, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.RH, "Codabar - RH - Same");
			Assert.AreEqual((decimal)840, tstBUM.PooledUnit.NewUnit.OriginalVolume, "Codabar - OriginalVolume");
			Assert.AreEqual(targetCost, tstBUM.PooledUnit.NewUnit.BloodUnitFinance.UnitCost, "Codabar - UnitCost");
			Assert.AreEqual(currentDate.AddYears(-1), tstBUM.PooledUnit.UnitExpirationDate, "Codabar - ExpirationDate");

			//Testing Mixed ABO/RHs..........
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			firstUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.B;
			firstUnit.BloodUnitMedia.AboRh.RH = Common.RH.Positive;

			secondUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.A;
			secondUnit.BloodUnitMedia.AboRh.RH = Common.RH.Negative;

			tstBUM.AddUnitToPool(firstUnit);
			tstBUM.AddUnitToPool(secondUnit);

			tstBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

			Assert.AreEqual(Common.ABO.Mx, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.Abo, "Codabar - ABO - Mix");
			Assert.AreEqual(Common.RH.PooledRH, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.RH, "Codabar - RH - Mix");

			string tstId = this.TestDivisionCode.Replace(" ", "0") + DateTime.Now.ToString("yy");
			Assert.AreEqual(tstId, tstBUM.PooledUnit.NewUnit.EyeReadableUnitId.Substring(0,7), "Codabar - UnitId");

			decimal prevVolume = tstBUM.PooledUnit.NewUnit.OriginalVolume;
			tstBUM.PooledUnit.NewUnit.OriginalVolume += 100;		//CodeCoverage for private method
			tstBUM.PooledUnit.NewUnit.OriginalVolume -= 101;		//CodeCoverage for private method
			Assert.AreEqual(--prevVolume, tstBUM.PooledUnit.NewUnit.OriginalVolume, "VolumeCheck");

			//***************************************************************************
			//*Run throguh again for an ISBT pool*****************************************
			//***************************************************************************
			this.CreatePoolForTests(true,false);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			firstUnit = _pooledUnitA;
			secondUnit = null;
			currentDate = System.DateTime.Now;

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (errors.Count == 0 && tstBU.EyeReadableUnitId != this._pooledUnitA.EyeReadableUnitId)
				{
					secondUnit = tstBU;
					break;
				}
			}

			//Testing BOL.BloodUnitModification.CalculatePooledProperties() ----------------------------
			firstUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.A;
			firstUnit.BloodUnitMedia.AboRh.RH = Common.RH.Negative;
			firstUnit.BloodUnitFinance.UnitCost = (decimal)420;
			firstUnit.OriginalVolume = (decimal)420;
			firstUnit.BloodUnitMedia.UnitExpirationDate = currentDate.AddYears(-1);

			secondUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.A;
			secondUnit.BloodUnitMedia.AboRh.RH = Common.RH.Negative;
			secondUnit.BloodUnitFinance.UnitCost = (decimal)420;
			secondUnit.OriginalVolume = (decimal)420;
			secondUnit.BloodUnitMedia.UnitExpirationDate = currentDate;

			tstBUM.AddUnitToPool(firstUnit);
			tstBUM.AddUnitToPool(secondUnit);

			tstBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

			//Calculate the charge of the final unit
			targetCost = decimal.Zero;
			targetCost = (decimal)840 + this.GetModificationCost(Common.ProductModification.Pooled, 1, this._poolCharge);

			Assert.AreEqual(Common.ABO.A, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.Abo, "ISBT - ABO - Same");
			Assert.AreEqual(Common.RH.Negative, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.RH, "ISBT - RH - Same");
			Assert.AreEqual((decimal)840, tstBUM.PooledUnit.NewUnit.OriginalVolume, "ISBT - OriginalVolume");
			Assert.AreEqual(targetCost, tstBUM.PooledUnit.NewUnit.BloodUnitFinance.UnitCost, "ISBT - UnitCost");
			Assert.AreEqual(currentDate.AddYears(-1), tstBUM.PooledUnit.UnitExpirationDate, "ISBT - ExpirationDate");
			

			//Testing Mixed ABO/RHs..........
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			firstUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.B;
			firstUnit.BloodUnitMedia.AboRh.RH = Common.RH.Positive;

			secondUnit.BloodUnitMedia.AboRh.Abo = Common.ABO.A;
			secondUnit.BloodUnitMedia.AboRh.RH = Common.RH.Negative;

			tstBUM.AddUnitToPool(firstUnit);
			tstBUM.AddUnitToPool(secondUnit);

			tstBUM.PoolUnits(this.MyLockController);
			tstBUM.PooledUnit.NewUnit.OriginalVolume += 5000;
			tstBUM.PooledUnit.NewUnit.OriginalVolume -= 5000;
            this.MyLockController.UnlockRecords();

			Assert.AreEqual(Common.ABO.Mx, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.Abo, "ISBT - ABO - Mix");
			Assert.AreEqual(Common.RH.PooledRH, tstBUM.PooledUnit.NewUnit.BloodUnitMedia.AboRh.RH, "ISBT - RH - Mix");
			Assert.AreEqual("00", tstBUM.PooledUnit.NewUnit.UnitDivisionId, "ISBT - UnitID");
		}

		[Test]
		public void PoolUnits_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);

			this.CreatePoolForTests(true,true);

			try 
			{
				tstBUM.PoolUnits(this.MyLockController);
				Assert.IsTrue(false, "PoolUnits should've raised an exception (<2 units)");
			}
			catch(BOL.BusinessObjectException)
			{
				Assert.AreEqual(true, true, "BusinessObjectException, <2 units");
			}

			DataTable dtCMV = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), this._pooledUnitA.BloodUnitGuid,  System.Convert.ToInt32(Common.TestType.CMV), "P");
			int rc = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertBloodUnitTest.StoredProcName, dtCMV);
			if (rc != 0) Assert.IsTrue(false, "CMV was not updated");

			tstBUM.AddUnitToPool(this._pooledUnitA);
			tstBUM.AddUnitToPool(this._pooledUnitB);

			//The CMV should be false if not all units match
			tstBUM.PoolUnits(this.MyLockController);
			Assert.AreEqual(false, tstBUM.PooledUnit.NewUnit.CmvNegative, "CMVNegative");

		}

		[Test]
		public void ModifyUnit_Pass()
		{
			this.RefreshData = true;

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			System.Guid unitGuid = this._thawGuid;

			//Set the UnitCost to Zero for code coverage
			UnitTestUtil.RunSQL("UPDATE BloodUnitFinance SET UnitCost = NULL WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			tstBUM.ModifyUnit(unitGuid);
			tstBUM.ModifiedUnit.NewUnit.OriginalVolume++;

			Assert.AreEqual(unitGuid, tstBUM.OriginalUnit.BloodUnitGuid, "Thaw");

			//Validate that the Modification Cost is only the division charge
			BOL.BloodProductModifications tmpBPM = new BOL.BloodProductModifications(this.TestDivisionCode);
			decimal tstCost = (decimal)tmpBPM.ModificationCosts[Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Thawed)];

			Assert.AreEqual(tstCost, tstBUM.ModifiedUnit.NewUnit.BloodUnitFinance.UnitCost, "ModificationCost");

			//Test VolumeReduce for coverage
			DataCreator.CreateModifiableBloodUnit(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Closed, false);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			DataTable dtVReduce = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Closed,false);
			unitGuid = (System.Guid)dtVReduce.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			
			//Assign a Patient , so we can fail Label Verification
			System.Guid patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(unitGuid, patientGuid, false);

			System.Guid[] thawOUGuids = {unitGuid, patientGuid};

			tstBUM.ModifyUnit(unitGuid);
			tstBUM.InheritedPatientAssignment = thawOUGuids;
			tstBUM.ModifiedUnit.LabelVerificationFailed = true;
			tstBUM.ModifiedUnit.NewUnit.DiscardedPlasmaVolume++;
			tstBUM.Save(Common.UpdateFunction.UnitTests);

			Assert.AreEqual(unitGuid, tstBUM.OriginalUnit.BloodUnitGuid, "VolumeReduce");

		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void ModifyUnit_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);

			tstBUM.ModifyUnit(System.Guid.NewGuid());
		}

		[Test]
		public void GetModifiableBloodUnits_Pass()
		{
			DataTable dtTest = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open,false);
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count-Split");

			//Test both paths
			DataTable dtTest2 = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open,false);
			Assert.AreEqual(true, dtTest2.Rows.Count > 0, "Rows.Count-EditPool");

		}

		[Test]
		public void GetModifiableBloodUnits_Fail()
		{
			DataTable dtTest = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Unknown, Common.ModifyUnitMethod.None,false);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetBloodUnitModificationsByUnitGuid_Pass()
		{
			BOL.BloodUnit tmpUnit = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, false);
			BOL.BloodUnitModification tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, DateTime.Now.AddHours(-5), Common.LogonUser.LogonUserName);
			tmpBUM.ModifyUnit(tmpUnit.BloodUnitGuid);

			DataTable dtTargets = tmpBUM.GetTargetBloodProducts(tmpBUM.GetBloodProductGuidArray());
			tmpBUM.ModifiedUnit.TargetBloodProduct = new BOL.BloodProduct(dtTargets.Rows[0]);
			tmpBUM.Save(Common.UpdateFunction.UnitTests);

			DataTable dtTest = BOL.BloodUnitModification.GetBloodUnitModificationsByUnitGuid(tmpUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitModificationsByUnitGuid_Fail()
		{
			DataTable dtTest = BOL.BloodUnitModification.GetBloodUnitModificationsByUnitGuid(System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void HasUnitBeenSplit_Pass()
		{
			//Codabar
			BOL.BloodUnit parentCodabarUnit = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, true);
			BOL.BloodUnitModification tstCodabarBUM = new BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstCodabarBUM.SplitUnit(parentCodabarUnit.BloodUnitGuid, 2);
			tstCodabarBUM.Save(Common.UpdateFunction.UnitTests);

			BOL.BloodUnit refreshedCodabarParent = new BOL.BloodUnit(parentCodabarUnit.BloodUnitGuid);
			bool retCodabarValue = BOL.BloodUnitModification.HasUnitBeenSplit(refreshedCodabarParent);
			Assert.AreEqual(false, retCodabarValue, "Codabar-parent");

			BOL.BloodUnit childCodabarSplit = new BOL.BloodUnit(((BOL.ModifiedUnit)tstCodabarBUM.SplitUnits[0]).ToBloodUnitGuid);
			retCodabarValue = BOL.BloodUnitModification.HasUnitBeenSplit(childCodabarSplit);
			Assert.AreEqual(true, retCodabarValue, "Codabar-child");

			//ISBT
			BOL.BloodUnit parentISBTUnit = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, false);
			BOL.BloodUnitModification tstISBTBUM = new BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstISBTBUM.SplitUnit(parentISBTUnit.BloodUnitGuid, 2);
			tstISBTBUM.Save(Common.UpdateFunction.UnitTests);

			BOL.BloodUnit refreshedISBTParent = new BOL.BloodUnit(parentISBTUnit.BloodUnitGuid);
			bool retISBTValue = BOL.BloodUnitModification.HasUnitBeenSplit(refreshedISBTParent);
			Assert.AreEqual(false, retISBTValue, "ISBT-parent");

			BOL.BloodUnit childISBTSplit = new BOL.BloodUnit(((BOL.ModifiedUnit)tstISBTBUM.SplitUnits[0]).ToBloodUnitGuid);
			retISBTValue = BOL.BloodUnitModification.HasUnitBeenSplit(childISBTSplit);
			Assert.AreEqual(true, retISBTValue, "ISBT-child");


		}

		[Test]
		public void HasUnitBeenSplit_Fail()
		{
			//Create some test data, just in case
			BOL.BloodUnit codabarUnit = DataCreator.CreateBloodUnit(true);
			BOL.BloodUnit isbtUnit = DataCreator.CreateBloodUnit(false);
			
			bool retValue = BOL.BloodUnitModification.HasUnitBeenSplit(codabarUnit);
			Assert.AreEqual(false, retValue, "Codabar");

			retValue = BOL.BloodUnitModification.HasUnitBeenSplit(isbtUnit);
			Assert.AreEqual(false, retValue, "ISBT");
		}

		[Test]
		public void LoadParentBloodUnitInformation_Pass()
		{
			BOL.BloodUnitModification bumThaw = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			BOL.BloodUnit parentUnit = new BOL.BloodUnit(this._thawGuid);
			bumThaw.ModifyUnit(parentUnit.BloodUnitGuid);
			
			DataTable dtParent = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);

			parentUnit.DiscardedPlasmaVolume = decimal.One;		//For code coverage
			DataRow drTest = bumThaw.LoadParentBloodUnitInformation(parentUnit, dtParent.NewRow());

			Assert.AreEqual(parentUnit.BloodUnitGuid, (System.Guid)drTest[TABLES.BloodUnit.BloodUnitGuid], "BloodUnitGuid");
			Assert.AreEqual(parentUnit.OriginalVolume, (decimal)drTest[TABLES.BloodUnit.OriginalVolume], "OriginalVolume");
			Assert.AreEqual(parentUnit.DiscardedPlasmaVolume, (decimal)drTest[TABLES.BloodUnit.DiscardedPlasmaVolume], "DiscardedPlasmaVolume");
			Assert.AreEqual(parentUnit.DonationType.DonationTypeId, (int)drTest[TABLES.BloodUnit.DonationTypeId], "DonationTypeId");
			Assert.AreEqual(parentUnit.RowVersion.Length, ((byte[])drTest[TABLES.BloodUnit.RowVersion]).Length, "RowVersion");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void LoadParentBloodUnitInformation_Fail()
		{
			BOL.BloodUnitModification bumThaw = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			BOL.BloodUnit parentUnit = new BOL.BloodUnit(this._thawGuid);
			bumThaw.ModifyUnit(parentUnit.BloodUnitGuid);

			DataTable dtParent = new DataTable();
			bumThaw.LoadParentBloodUnitInformation(parentUnit, dtParent.NewRow());
		}


		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;
			
			System.Collections.ArrayList supplyList = new System.Collections.ArrayList();
			System.Collections.ArrayList equipmentList = new System.Collections.ArrayList();
			System.Guid patientGuid = System.Guid.NewGuid();
			System.Guid unitGuid = this._thawGuid;
			System.Guid patient2Guid = System.Guid.NewGuid();

			//Add a patient assignment to our unit - this one we won't keep
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(unitGuid, patientGuid, false);

			//this one we will keep. why don't we keep the first one?? who the hell writes this crap??!
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(unitGuid, patientGuid, false);
			DataCreator.CreatePatientAssignment(unitGuid, patient2Guid, false);

			System.Guid[] thawOUGuids = {unitGuid, patientGuid, unitGuid, patient2Guid};

			//Add our base supplies to the arraylists
			supplyList.Add(this._supply);
			equipmentList.Add(this._equipment);

			//Thaw - Will fire PrepareAndSaveModification-----------------------------------------------------------------------------
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			//Create a BloodUnitMedia Comment - for code coverage
			UnitTestUtil.RunSQL("UPDATE BloodUnitMedia SET Comments = 'Save_Pass()-7018' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");
			tstBUM.ModifyUnit(unitGuid);
			tstBUM.InheritedPatientAssignment = thawOUGuids;

			//Create an exception -- for code coverage
			BOL.ExceptionReport tmpExc1 = new BOL.ExceptionReport(Common.ExceptionType.Expired_Supply_UnitModification, "UT ModifyUnit_Pass(7012)", Common.LogonUser.LogonUserName);
			tmpExc1.GenerateExceptionUnitModification(tstBUM.ModifiedUnit.NewUnit, tstBUM, tstBUM.ModifiedUnit.RecommendedExpirationDateTime(tstBUM), null);
			tstBUM.Exceptions.Add(tmpExc1);

			//Create a supply exception for code coverage
			BOL.Supply excSupply = new BOL.Supply(this._supply.SupplyGuid);
			BOL.ExceptionReport tmpExc2 = new BOL.ExceptionReport(Common.ExceptionType.Expired_Supply_UnitModification, "UT ModifyUnit_Pass(7012)", Common.LogonUser.LogonUserName);
			tmpExc2.GenerateExceptionUnitModification(tstBUM.ModifiedUnit.NewUnit, tstBUM, tstBUM.ModifiedUnit.RecommendedExpirationDateTime(tstBUM), excSupply);
			excSupply.LotException = tmpExc2;
			supplyList.Add(excSupply);

			DataTable targetProducts = tstBUM.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray());
			if (targetProducts.Rows.Count == 0)
				Assert.IsTrue(false, "Thaw Target not found - " + tstBUM.GetBloodProductGuidArray());

			System.Guid targetBPGuid = (System.Guid)targetProducts.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			tstBUM.ModifiedUnit.TargetBloodProduct = new BOL.BloodProduct(targetBPGuid);
			tstBUM.ModifiedUnit.SupplyList = supplyList;
			tstBUM.ModifiedUnit.Container = this._container;
			tstBUM.ModifiedUnit.EquipmentList = equipmentList;
			tstBUM.ModifiedUnit.NewLabelVerificationDateTime = System.DateTime.Now;
			tstBUM.Comments = "I didn't really do label verification on this unit.  UnitTest(7018)";

			bool retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PrepareAndSaveModification");

			//Yank the supply exception to avoid PrimaryKey exploseeon
			supplyList.RemoveAt(1);

			//End Thaw----------------------------------------------------------------------------------------------------------------

			//Pool - Will fire PrepareAndSavePool-------------------------------------------------------------------------------------
			this.CreatePoolForTests(true, true);		//Create some poolable units
			this.CreatePoolForTests(true, true);		//Create some poolable units
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.AddUnitToPool(this._pooledUnitA);

			//Add a patient assignment to our first unit in pool
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patientGuid, false);

			patient2Guid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patient2Guid, false);

			System.Guid[] poolOUGuids = {this._pooledUnitA.BloodUnitGuid, patientGuid, this._pooledUnitA.BloodUnitGuid, patient2Guid};
			tstBUM.InheritedPatientAssignment = poolOUGuids;

			DataRow[] drValids = this._dtPool.Select("BloodProductGuid = '" + this._pooledUnitA.BloodProductGuid.ToString() + "'");
			foreach(DataRow dr in drValids)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (errors.Count == 0)
				{
					tstBUM.AddUnitToPool(tstBU);
				}

				if (tstBUM.PoolingUnits.Count > 1)
					break;
			}

			tstBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

            targetProducts = tstBUM.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray());
			if (targetProducts.Rows.Count == 0)
				Assert.IsTrue(false, "Pool Target not found - " + tstBUM.GetBloodProductGuidArray());

			targetBPGuid = (System.Guid)targetProducts.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			tstBUM.PooledUnit.TargetBloodProduct = new BOL.BloodProduct(targetBPGuid);
			
			//Validate that the ProductSupplier exists, if not create it  -- the UI would normally take care of this
			DataTable psCheck = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductShipper WHERE DivisionCode = '" + this.TestDivisionCode + "' AND LocalSupplierGuid = '" + tstBUM.PooledUnit.NewUnit.IncomingShipment.LocalSupplierGuid + "' AND BloodProductGuid = '" + targetBPGuid.ToString() + "'", false);
			System.Guid psGuid = System.Guid.NewGuid();
			if (psCheck.Rows.Count == 0)
			{
				DataTable dtInsPS = SprocHelper.GetInsertProductShipperSprocTable(psGuid, targetBPGuid, tstBUM.PooledUnit.NewUnit.IncomingShipment.LocalSupplierGuid);
				int rcIns = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertProductShipper.StoredProcName, dtInsPS);
				Assert.AreEqual(0, rcIns, "Insert of ProductShipper for Pool");
			}
			else
			{
				if (psCheck.Rows[0][TABLES.ProductShipper.RecordStatusCode].ToString() != "A")
				{
					psGuid = (System.Guid)psCheck.Rows[0][TABLES.ProductShipper.ProductShipperGuid];
					byte[] psRowVersion = (byte[])psCheck.Rows[0][TABLES.ProductShipper.RowVersion];

					DataTable dtUpdPS = SprocHelper.GetUpdateProductShipperSprocTable(psGuid, psRowVersion, "A");
					int rcUpd = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.UpdateProductShipper.StoredProcName, dtUpdPS);
					Assert.AreEqual(0, rcUpd, "Update of ProductShipper for Pool");
				}
			}

			tstBUM.PooledUnit.SupplyList = supplyList;
			tstBUM.PooledUnit.EquipmentList = equipmentList;

			if (this.DoesPoolViolateCheckContraint(tstBUM))	
				tstBUM.PooledUnit.NewUnit.SetEyeReadableUnitId(System.DateTime.Now.ToString("yyMMddHHmmss"), false);

			retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PrepareAndSavePool");
			//End Pool----------------------------------------------------------------------------------------------------------------


			//EditPool1 - Will fire PrepareAndSaveEditPool-----------------------------------------------------------------------------
			this.CreatePoolForTests(true, true);
			System.Guid poolGuid1 = this.CreatePoolForTests(false, true);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid1);
			int prevUnits1 = tstBUM.PoolingUnits.Count;
			Assert.AreEqual(2, prevUnits1, "Edit1-PooledUnits.Count");

			this._dtPool = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open,false);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (errors.Count == 0)
				{
					tstBUM.AddUnitToPool(tstBU);
					if (tstBUM.PoolingUnits.Count > prevUnits1)
						break;
				}
			}
			Assert.AreEqual(true, tstBUM.PoolingUnits.Count > prevUnits1, "1-New units added to pool");

			//Create a patient assignment for the main unit
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patientGuid, false);
			patient2Guid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patient2Guid, false);
			System.Guid[] edit1OUGuids = {this._pooledUnitA.BloodUnitGuid, patientGuid, this._pooledUnitA.BloodUnitGuid, patient2Guid};
			tstBUM.InheritedPatientAssignment = edit1OUGuids;

			//Now we also test the removing of units --- so remove _pooledB
			tstBUM.RemoveUnitFromPool(this._pooledUnitB.BloodUnitGuid);

			targetProducts = tstBUM.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray());
			if (targetProducts.Rows.Count == 0)
				Assert.IsTrue(false, "EditPool1 Target not found - " + tstBUM.GetBloodProductGuidArray());

			//Now we also need to test the add/removal of supplies and equipment -- so create a new supply/equip and yoink the old
			System.Guid equipGuid1 = System.Guid.NewGuid();
			System.Guid supplyGuid1 = System.Guid.NewGuid();

			DataTable dtNewEquip1 = SprocHelper.GetInsertEquipmentSprocTable(equipGuid1, this._equipment.ManufacturerAddress.AddressGuid);
			int insEquip1 = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertEquipment.StoredProcName, dtNewEquip1);
			Assert.AreEqual(0, insEquip1, "EditPool1 Equipment Insert");

			DataTable dtNewSupply1 = SprocHelper.GetInsertSupplySprocTable(supplyGuid1);
			int insSupply1 = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertSupply.StoredProcName, dtNewSupply1);
			Assert.AreEqual(0, insSupply1, "EditPool1 Supply Insert");

			supplyList.Clear();
			supplyList.Add(new BOL.Supply(supplyGuid1));
			supplyList.Add(this._supply);	//add an existing supply
			equipmentList.Clear();
			equipmentList.Add(new BOL.Equipment(equipGuid1));
			equipmentList.Add(this._equipment);	//add an existing equipment

			//Make sure the target blood product exists
			targetBPGuid = (System.Guid)targetProducts.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			tstBUM.PooledUnit.TargetBloodProduct = new BOL.BloodProduct(targetBPGuid);
			tstBUM.PooledUnit.SupplyList = supplyList;
			tstBUM.PooledUnit.EquipmentList = equipmentList;
			tstBUM.PoolUnits(this.MyLockController);
			tstBUM.PooledUnit.NewLabelVerificationDateTime = System.DateTime.Now;
            this.MyLockController.UnlockRecords();

			//Remove the CMV record - code is in place to insert one if it doesn't exist
			UnitTestUtil.RunSQL("DELETE FROM BloodUnitTest WHERE BloodUnitGuid = '" + tstBUM.PooledUnit.NewUnit.BloodUnitGuid.ToString() + "' AND BloodTestTypeId = " + ((int)Common.TestType.CMV).ToString());

			retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PrepareAndSaveEditPool1");

			//EditPool1 End-----------------------------------------------------------------------------------------------------------

			//EditPool2 - Will fire PrepareAndSaveEditPool-----------------------------------------------------------------------------
			this.CreatePoolForTests(true, true);
			System.Guid poolGuid2 = this.CreatePoolForTests(false, true);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid2);
			int prevUnits2 = tstBUM.PoolingUnits.Count;
			Assert.AreEqual(2, prevUnits2, "Edit2-PooledUnits.Count");

			//Refresh our units
			this._dtPool = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open,false);

			foreach(DataRow dr in this._dtPool.Rows)
			{
				BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

				System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

				if (errors.Count == 0)
				{
					tstBUM.AddUnitToPool(tstBU);
					if (tstBUM.PoolingUnits.Count > prevUnits2)
					{
						//Now that we have our latest unit, add a CMV record for code coverage (if not exists)
						if (!tstBU.CmvNegative)
						{
							DataTable dtTmpBUT = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE BloodUnitGuid = '" + tstBU.BloodUnitGuid + "' AND BloodTestTypeId = 103");
							if (dtTmpBUT.Rows.Count == 0)
							{
                                UnitTestUtil.RunSQL("INSERT INTO BloodUnitTest(BloodUnitTestGuid, BloodUnitGuid, BloodTestTypeId, TestDate, TestTechId, TestResultId, EntryTechId, EntryMethodCode, RecordStatusCode, DivisionCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES(newid(), '" + tstBU.BloodUnitGuid.ToString() + "', 103, getdate(), '" + Environment.UserName + "', 'P', '" + Environment.UserName + "', 'M', 'A', '" + this.TestDivisionCode + "', getdate(), '" + Environment.UserName + "', 999)");
							}
							else
							{
								UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestResultId = 'P' WHERE BloodUnitGuid = '" + tstBU.BloodUnitGuid.ToString() + "' AND BloodTestTypeId = 103");
							}
						}
						break;
					}
				}
			}
			Assert.AreEqual(true, tstBUM.PoolingUnits.Count > prevUnits2, "2-New units added to pool");

			//Create a patient assignment for the main unit
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patientGuid, false);
			patient2Guid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patient2Guid, false);
			System.Guid[] edit2OUGuids = {this._pooledUnitA.BloodUnitGuid, patientGuid, this._pooledUnitA.BloodUnitGuid, patient2Guid};
			tstBUM.InheritedPatientAssignment = edit2OUGuids;

			//Now we also test the removing of units --- so remove _pooledB
			tstBUM.RemoveUnitFromPool(this._pooledUnitB.BloodUnitGuid);

			targetProducts = tstBUM.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray());
			if (targetProducts.Rows.Count == 0)
				Assert.IsTrue(false, "EditPool2 Target not found - " + tstBUM.GetBloodProductGuidArray());

			//Now we also need to test the add/removal of supplies and equipment -- so create a new supply/equip and yoink the old
			System.Guid equipGuid2 = System.Guid.NewGuid();
			System.Guid supplyGuid2 = System.Guid.NewGuid();

			DataTable dtNewEquip2 = SprocHelper.GetInsertEquipmentSprocTable(equipGuid2, this._equipment.ManufacturerAddress.AddressGuid);
			int insEquip2 = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertEquipment.StoredProcName, dtNewEquip2);
			Assert.AreEqual(0, insEquip2, "EditPool2 Equipment Insert");

			DataTable dtNewSupply2 = SprocHelper.GetInsertSupplySprocTable(supplyGuid2);
			int insSupply2 = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertSupply.StoredProcName, dtNewSupply2);
			Assert.AreEqual(0, insSupply2, "EditPool2 Supply Insert");

			supplyList.Clear();
			supplyList.Add(new BOL.Supply(supplyGuid2));
			supplyList.Add(this._supply);	//add an existing supply
			equipmentList.Clear();
			equipmentList.Add(new BOL.Equipment(equipGuid2));
			equipmentList.Add(this._equipment);	//add an existing equipment

			//Make sure the target blood product exists
			targetBPGuid = (System.Guid)targetProducts.Rows[0][TABLES.BloodUnit.BloodProductGuid];
			tstBUM.PooledUnit.TargetBloodProduct = new BOL.BloodProduct(targetBPGuid);
			tstBUM.PooledUnit.SupplyList = supplyList;
			tstBUM.PooledUnit.EquipmentList = equipmentList;
			tstBUM.PoolUnits(this.MyLockController);
			tstBUM.PooledUnit.NewLabelVerificationDateTime = System.DateTime.Now;
            this.MyLockController.UnlockRecords();
	
			tstBUM.PooledUnit.LabelVerificationFailed = true;
			retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PrepareAndSaveEditPool2");

			//EditPool2 End-----------------------------------------------------------------------------------------------------------

			//Split1 - will fire PrepareAndSaveSplit-----------------------------------------------------------------------------------
			//Create a bloodunit to split --- we create, so we can add tests, assignments
			System.Guid split1BUGuid = System.Guid.NewGuid();
			System.Guid split1BPGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE ProductCode = '04020'");

			DataCreator.CreateBloodUnit(split1BUGuid, System.Guid.NewGuid(), System.Guid.Empty, split1BPGuid, true);

			BOL.BloodUnit split1Unit = new BOL.BloodUnit(split1BUGuid);
			//Splitting code coverage -- create some antigen info -- jic
			DataTable dtAntigens = SprocHelper.GetInsertBloodUnitAntigenSprocTable(split1Unit.BloodUnitGuid);
			new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertBloodUnitAntigen.StoredProcName, dtAntigens);

			//Create a CMV test for code coverage - (BloodUnitTest records)
			DataTable dtBloodUnitTests = SprocHelper.GetInsertBloodUnitTestSprocTable(System.Guid.NewGuid(), split1Unit.BloodUnitGuid, (int)Common.TestType.CMV, "P");
			new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertBloodUnitTest.StoredProcName, dtBloodUnitTests);
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(split1BUGuid, patientGuid, false);
			patient2Guid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(split1BUGuid, patient2Guid, false);

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.SterileConnectingDevice, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(split1Unit.BloodUnitGuid, 2);

			//Deactivate the ProductShipper, so we can validate the the shipper will become active (via Code in BUM)
			System.Guid psGuidSplit = DataCreator.GetRecordGuid("SELECT TOP 1 ProductShipperGuid FROM ProductShipper WHERE LocalSupplierGuid = (SELECT LocalSupplierGuid FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "') AND BloodProductGuid = '" + split1BPGuid.ToString() + "' AND Divisioncode = '" + this.TestDivisionCode + "'");
			UnitTestUtil.RunSQL("UPDATE ProductShipper SET RecordStatusCode = 'X' WHERE ProductShipperGuid = '" + psGuidSplit + "'");

			System.Guid[] split1OUGuids = {split1BUGuid, patientGuid, split1BUGuid, patient2Guid};
			tstBUM.InheritedPatientAssignment = split1OUGuids;
			
			tstBUM.SetOriginalContainerIndicator(0,true);

			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).Container = this._container;
			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).SupplyList = supplyList;
			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).EquipmentList = equipmentList;

			tstBUM.NewContainerWeldIndicator = true;

			retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "PrepareAndSaveEditSplit1");
			//Split1 End ------------------------------------------------------------------------------------------------------------

			//Split2 - will fire PrepareAndSaveSplit-----------------------------------------------------------------------------------
			//Create a bloodunit to split --- we create, so we can add tests, assignments
			System.Guid split2BUGuid = System.Guid.NewGuid();
			//Grab a product that's not being used (to test unreachable code in LoadShipmentInformation)
			System.Guid split2BPGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE ProductCodeIndicator = 0 AND BloodProductGuid NOT IN (SELECT DISTINCT BloodProductGuid FROM ProductShipper)");
			
			DataCreator.CreateBloodUnit(split2BUGuid, System.Guid.NewGuid(), System.Guid.Empty, split2BPGuid, true);
			BOL.BloodUnit split2Unit = new BOL.BloodUnit(split2BUGuid);

			//Create patient assignments
			patientGuid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(split2BUGuid, patientGuid, false);
			patient2Guid = System.Guid.NewGuid();
			DataCreator.CreatePatientAssignment(split2BUGuid, patient2Guid, false);

			//This will cause LoadShipmentInformation to be activated
			UnitTestUtil.RunSQL("DELETE FROM ProductShipper WHERE BloodProductGuid = '" + split2BPGuid.ToString() + "'");

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.SterileConnectingDevice, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(split2Unit.BloodUnitGuid, 2);

			System.Guid[] split2OUGuids = {split2BUGuid, patientGuid, split2BUGuid, patient2Guid};
			tstBUM.InheritedPatientAssignment = split2OUGuids;
			((BOL.ModifiedUnit)tstBUM.SplitUnits[0]).LabelVerificationFailed = true;
			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).LabelVerificationFailed = true;

			tstBUM.SetOriginalContainerIndicator(0,true);

			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).Container = this._container;
			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).SupplyList = supplyList;
			((BOL.ModifiedUnit)tstBUM.SplitUnits[1]).EquipmentList = equipmentList;

			tstBUM.NewContainerWeldIndicator = true;

			retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "PrepareAndSaveEditSplit2");
			//Split2 End ------------------------------------------------------------------------------------------------------------
		}

        [Test]
        public void PrepareAndSaveEditedPool_ExistingPatientAssignment()
        {
            this.CreatePoolForTests(true, true);
            System.Guid poolGuid2 = this.CreatePoolForTests(false, true);
            System.Guid patientGuid = System.Guid.NewGuid();
            DataCreator.CreatePatientAssignment(poolGuid2, patientGuid, false);

            BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
            tstBUM.EditPool(poolGuid2);
            int prevUnits2 = tstBUM.PoolingUnits.Count;
            Assert.AreEqual(2, prevUnits2, "Edit2-PooledUnits.Count");

            //Refresh our units
            this._dtPool = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, false);

            foreach (DataRow dr in this._dtPool.Rows)
            {
                BOL.BloodUnit tstBU = new BOL.BloodUnit((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);

                System.Collections.ArrayList errors = tstBUM.ValidateAddingPoolUnit(tstBU);

                if (errors.Count == 0)
                {
                    tstBUM.AddUnitToPool(tstBU);
                    if (tstBUM.PoolingUnits.Count > prevUnits2)
                    {
                        break;
                    }
                }
            }
            Assert.AreEqual(true, tstBUM.PoolingUnits.Count > prevUnits2, "2-New units added to pool");

            //Create a patient assignment for the main unit
            DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, patientGuid, true);
            System.Guid[] edit2OUGuids = { this._pooledUnitA.BloodUnitGuid, patientGuid };
            tstBUM.InheritedPatientAssignment = edit2OUGuids;

            DataTable targetProducts = tstBUM.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray());
            if (targetProducts.Rows.Count == 0)
                Assert.IsTrue(false, "EditPool2 Target not found - " + tstBUM.GetBloodProductGuidArray());

            ////Now we also need to test the add/removal of supplies and equipment -- so create a new supply/equip and yoink the old
            //System.Guid equipGuid2 = System.Guid.NewGuid();
            //System.Guid supplyGuid2 = System.Guid.NewGuid();

            //DataTable dtNewEquip2 = SprocHelper.GetInsertEquipmentSprocTable(equipGuid2, this._equipment.ManufacturerAddress.AddressGuid);
            //int insEquip2 = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertEquipment.StoredProcName, dtNewEquip2);
            //Assert.AreEqual(0, insEquip2, "EditPool2 Equipment Insert");

            //DataTable dtNewSupply2 = SprocHelper.GetInsertSupplySprocTable(supplyGuid2);
            //int insSupply2 = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertSupply.StoredProcName, dtNewSupply2);
            //Assert.AreEqual(0, insSupply2, "EditPool2 Supply Insert");

            //supplyList.Clear();
            //supplyList.Add(new BOL.Supply(supplyGuid2));
            //supplyList.Add(this._supply);	//add an existing supply
            //equipmentList.Clear();
            //equipmentList.Add(new BOL.Equipment(equipGuid2));
            //equipmentList.Add(this._equipment);	//add an existing equipment

            //Make sure the target blood product exists
            System.Guid targetBPGuid = (System.Guid)targetProducts.Rows[0][TABLES.BloodUnit.BloodProductGuid];
            tstBUM.PooledUnit.TargetBloodProduct = new BOL.BloodProduct(targetBPGuid);
            //tstBUM.PooledUnit.SupplyList = supplyList;
            //tstBUM.PooledUnit.EquipmentList = equipmentList;
            tstBUM.PoolUnits(this.MyLockController);
            //tstBUM.PooledUnit.NewLabelVerificationDateTime = System.DateTime.Now;
            this.MyLockController.UnlockRecords();
            tstBUM.PooledUnit.LabelVerificationFailed = false;
            bool retValue = tstBUM.Save(Common.UpdateFunction.UnitTests);
            Assert.AreEqual(true, retValue, "PrepareAndSaveEditPool2");
        }

	    [Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void Save_Fail()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Unknown, Common.ModifyUnitMethod.None, System.DateTime.Now, Common.LogonUser.LogonUserName);

			tstBUM.Save(Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void ValidateBusinessRules_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			BOL.BloodUnit tstBU = null;

//			foreach(DataRow drUnit in this._dtThaw.Rows)
//			{
//				if (drUnit[TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString() == "A")
//				{
					tstBU = new BOL.BloodUnit(this._thawGuid);
//					break;
//				}
//			}

			//Letting an assigned unit slip thru for more coverage
			DataCreator.CreatePatientAssignment(tstBU.BloodUnitGuid, System.Guid.NewGuid(), false);
			
			BOL.VbecsUser tmpUser = this.TestUser;
			tmpUser.LogonToDivision(this.TestDivisionCode);

			System.Collections.ArrayList tstValue = tstBUM.ValidateBusinessRules(tstBU, tmpUser);

			Assert.IsNotNull(tstValue);	
		}

		[Test]
		public void ValidateBusinessRules_Fail()
		{
			bool tstValue = false;

			// There are not any failure conditions. We just want to make
			// sure that 100% of the method is covered during testing.
			System.Collections.ArrayList tstRC = new System.Collections.ArrayList();

			BOL.VbecsUser user = this.TestUser;
			user.LogonToDivision(Common.LogonUser.LogonUserDivisionCode);

			//Split check - make sure it hasn't already been split or pooled
			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.SterileConnectingDevice, this._modificationDateTime, Common.LogonUser.LogonUserName);
////////////			BOL.BloodUnit tstBU = null;

//////////			DataTable dtSplitUnits = UnitTestUtil.RunSQLGetDataTable("SELECT BUM.ToBloodUnitGuid, V.UnitStatusCode FROM bloodunitmodification bum JOIN vw_BloodShipAllCurrent V ON BUM.ToBloodUnitGuid = V.BloodUnitGuid AND V.UnitStatusCode IN ('L','A') JOIN BloodProduct BP on bp.bloodproductguid = bum.frombloodproductguid and bum.productmodificationcode = 'S'");
			BOL.BloodUnit tstBU = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, false);

//////////			//Make sure the unit is Available to process all paths
//////////			foreach(DataRow drUnit in dtSplitUnits.Rows)
//////////			{
//////////				if (drUnit[TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString() == "A")
//////////				{
//////////					tstBU = new BOL.BloodUnit((System.Guid)drUnit[TABLES.BloodUnitModification.ToBloodUnitGuid]);
//////////					break;
//////////				}
//////////			}
//////////			//None of the units WERE "Available"?? curse you RBC!!!
//////////			if (tstBU == null)
//////////			{	
//////////				BOL.BloodUnit yarrgh = DataCreator.CreateRBCBloodUnit(true);
//////////				DataCreator.CreateAboRhConfirmationTestsForUnit(yarrgh.BloodUnitGuid, yarrgh.BloodUnitMedia.AboRh);
//////////				tstBU = new BOL.BloodUnit(yarrgh.BloodUnitGuid);
//////////			}

			tstValue = false;
			tstBU.BloodUnitStatus.QuarantineIndicator = true;
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if(tstItem.Message == Common.StrRes.ValidMsg.UC026.BR6QuarantineUnit(tstBU.EyeReadableUnitId,tstBU.ProductType.ProductTypeText).ResString)
				//if (tstItem.Message == Common.StrRes.SysErrMsg.UC025.UnitAlreadySplit().ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "BR_26.BR6QuarantineUnit");

			//Get an non-split unit for playing with
			BOL.BloodUnit tstOrigBU = DataCreator.CreateRBCBloodUnit(true);
			System.Guid unitGuid = tstOrigBU.BloodUnitGuid;
			tstBU = new BOL.BloodUnit(unitGuid);

			//Split check - Not enough volume for minimum # of splits
			tstValue = false;
			tstBU.OriginalVolume = 1;
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.SysErrMsg.UC025.NotEnoughVolumeToSplit().ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "BR_25.01");
			tstBU.OriginalVolume = tstOrigBU.OriginalVolume;

			//Verify the UnitDivisionID does not start with a number
			tstValue = false;
			string origDivisionId = tstBU.UnitDivisionId;
			Common.BarcodeType origBarcodeType = tstBU.BarcodeType;
			tstBU.BarcodeType = Common.BarcodeType.ISBT128;

			tstBU.UnitDivisionId = "90";
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.InfoMsg.UC025.SplitNotAllowed().ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "7th digit productcode is a number");

			//Verify the UnitDivisionID does not start withlowercase char
			tstValue = false;
			tstBU.UnitDivisionId = "b0";
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.InfoMsg.UC025.SplitNotAllowed().ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "7th digit productcode is a lowercase char");

			//Verify the unit hasn't already been split
			tstValue = false;
			tstBU.UnitDivisionId = "A1";
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.SysErrMsg.UC025.UnitAlreadySplit().ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "Unit has already been split");
			tstBU.UnitDivisionId = origDivisionId;
			tstBU.BarcodeType = origBarcodeType;

			//UnitStatusCode check
			tstValue = false;
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE UnitStatusCode = 'T' AND BloodUnitGuid NOT IN (SELECT ToBloodUnitGUID FROM BloodUnitModification)", false);
			if (dtTest.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
				dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE UnitStatusCode = 'T' AND BloodUnitGuid NOT IN (SELECT ToBloodUnitGUID FROM BloodUnitModification)", true);
			}
			BOL.BloodUnit junkUnit = new BOL.BloodUnit((System.Guid)dtTest.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
			tstRC = tstBUM.ValidateBusinessRules(junkUnit, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC026.BR33InvalidUnitStatus(junkUnit.EyeReadableUnitId, junkUnit.ProductType.ProductTypeText, junkUnit.BloodUnitStatus.UnitStatusText).ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "BR_26.33");		

			//ShipmentDate > UnitModificationDate BR_26.08
			tstValue = false;
			tstBU.IncomingShipment.ShipmentDate = this._modificationDateTime.AddMinutes(30);
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC026.BR8ModificationDate().ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "BR_26.08");
			tstBU.IncomingShipment.ShipmentDate = tstOrigBU.IncomingShipment.ShipmentDate;

			//Quarrantine Indicator -- Tech cannot do
			tstValue = false;
			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.Technologist);
			tstBU.BloodUnitStatus.QuarantineIndicator = true;
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC026.BR5QuarantineUnit(tstBU.EyeReadableUnitId,tstBU.ProductType.ProductTypeText).ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "BR_26.05");

			//Quarantine Indicator == Enhanced Tech or better can override
			tstValue = false;
			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.EnhancedTechnologist);
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.ReturnAction == Common.VerifyAction.Release)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "BR_26.06");	
			tstBU.BloodUnitStatus.QuarantineIndicator = false;

			//EditPool test - Assigned unit with not enough access privs
			tstValue = false;
			System.Guid poolGuid = this.CreatePoolForTests(false, true);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstBUM.EditPool(poolGuid);
			DataCreator.CreatePatientAssignment(this._pooledUnitA.BloodUnitGuid, System.Guid.NewGuid(), false);
			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.LeadTechnologist);
			tstRC = tstBUM.ValidateBusinessRules(this._pooledUnitA, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.InfoMsg.Common.InsufficientSecurityPrivileges("edit this pooled unit").ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "Limitations - UC_24 < TraditionalSupervisor");	

			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.TraditionalSupervisor);
			tstRC = tstBUM.ValidateBusinessRules(this._pooledUnitA, user);
			Assert.AreEqual(0, tstRC.Count, "Limitations - UC_24 >=TraditionalSupervisor");	

			//Volume Reduce -- Volume < 2
			tstValue = false;
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstBU.OriginalVolume = 1;
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == "Unit volume is too low.  Cannot modify.")
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "VolumeRuduce - Volume < 2ml");	
			tstBU.OriginalVolume = tstOrigBU.OriginalVolume;

			//Rejuvenate -- RBC -- Expired Unit - tech
			tstValue = false;
			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.Technologist);
			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Rejuvenated, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstBU.BloodUnitMedia.UnitExpirationDate = this._modificationDateTime.AddMonths(-1);
			tstBU.ProductType = new BOL.ProductType("E001");		//RBC?
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC026.BR3ExpiredUnit(tstBU.EyeReadableUnitId,tstBU.ProductType.ProductTypeText).ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "Expired Unit - Tech");

			//Expired Unit - non-tech
			tstValue=false;
			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.EnhancedTechnologist);
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.ReturnAction == Common.VerifyAction.OverrideExpiration)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "Expired Unit - Tech");

			tstBU.ProductType = tstOrigBU.ProductType;
			tstBU.BloodUnitMedia.UnitExpirationDate = this._modificationDateTime.AddYears(1);

			//BiohazardousWarning
			tstValue = false;
			user.CurrentDivisionRole.Role = new UserRole(Common.UserRoleType.AdministratorSupervisor);	//max user to avoid tripping any BRs
			tstBU.BloodUnitStatus.BiohazardousWarningIndicator = true;
			tstRC = tstBUM.ValidateBusinessRules(tstBU, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.ReturnAction == Common.VerifyAction.OverrideBiohazard)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "Biohazardous Unit");
			tstBU.BloodUnitStatus.BiohazardousWarningIndicator = false;

			//Limited Status 
			tstValue = false;
			junkUnit = new BOL.BloodUnit(DataCreator.CreateRBCBloodUnit(true).BloodUnitGuid);		//ugh, have to reload to get UnitStatus
			junkUnit.BloodUnitStatus.QuarantineIndicator = false;
			junkUnit.BloodUnitMedia.UnitExpirationDate = System.DateTime.Now.AddMonths(1);
			tstRC = tstBUM.ValidateBusinessRules(junkUnit, user);
			foreach(Common.ActionItem tstItem in tstRC)
			{
				if (tstItem.Message == Common.StrRes.ValidMsg.UC026.BR7ABORh(junkUnit.EyeReadableUnitId, junkUnit.ProductType.ProductTypeText).ResString)
				{					tstValue = true;				}
			}
			Assert.AreEqual(true, tstValue, "Unconfirmed Unit");
		}

		[Test]
		public void IsPool_Pass()
		{
			BOL.BloodUnitModification tstBUM;

			tstBUM = new BloodUnitModification(Common.ProductModification.Pooled, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(true, tstBUM.IsPool, "Pooled");

			tstBUM = new BloodUnitModification(Common.ProductModification.PoolThawCryo, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(true, tstBUM.IsPool, "PoolThawCryo");

			tstBUM = new BloodUnitModification(Common.ProductModification.EditPool, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(true, tstBUM.IsPool, "EditPool");
		}

		[Test]
		public void IsPool_Fail()
		{
			BOL.BloodUnitModification tstBUM;

			tstBUM = new BloodUnitModification(Common.ProductModification.Deglycerolized, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "Deglycerolized");

			tstBUM = new BloodUnitModification(Common.ProductModification.Frozen, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "Frozen");

			tstBUM = new BloodUnitModification(Common.ProductModification.Irradiated, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "Irradiated");

			tstBUM = new BloodUnitModification(Common.ProductModification.LeukoReduced, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "LeukoReduced");

			tstBUM = new BloodUnitModification(Common.ProductModification.Rejuvenated, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "Rejuvenated");

			tstBUM = new BloodUnitModification(Common.ProductModification.SplitAdult, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "SplitAdult");

			tstBUM = new BloodUnitModification(Common.ProductModification.Thawed, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "Thawed");

			tstBUM = new BloodUnitModification(Common.ProductModification.VolumeReduced, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "VolumeReduced");

			tstBUM = new BloodUnitModification(Common.ProductModification.Washed, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsPool, "Washed");
		}

		[Test]
		public void IsSplit_Pass()
		{
			BOL.BloodUnitModification tstBUM = new BloodUnitModification(Common.ProductModification.SplitAdult, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(true, tstBUM.IsSplit, "SplitAdult");
		}

		[Test]
		public void IsSplit_Fail()
		{
			BOL.BloodUnitModification tstBUM;

			tstBUM = new BloodUnitModification(Common.ProductModification.Deglycerolized, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "Deglycerolized");

			tstBUM = new BloodUnitModification(Common.ProductModification.Frozen, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "Frozen");

			tstBUM = new BloodUnitModification(Common.ProductModification.Irradiated, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "Irradiated");

			tstBUM = new BloodUnitModification(Common.ProductModification.LeukoReduced, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "LeukoReduced");

			tstBUM = new BloodUnitModification(Common.ProductModification.Rejuvenated, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "Rejuvenated");

			tstBUM = new BloodUnitModification(Common.ProductModification.Thawed, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "Thawed");

			tstBUM = new BloodUnitModification(Common.ProductModification.VolumeReduced, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "VolumeReduced");

			tstBUM = new BloodUnitModification(Common.ProductModification.Washed, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "Washed");

			tstBUM = new BloodUnitModification(Common.ProductModification.PoolThawCryo, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "PoolThawCryo");

			tstBUM = new BloodUnitModification(Common.ProductModification.EditPool, this._modificationMethod, this._modificationDateTime, Common.LogonUser.LogonUserName);
			Assert.AreEqual(false, tstBUM.IsSplit, "EditPool");
		}

		[Test]
		public void GetBloodProductGuidArray_Pass()
		{
			string checkValue = string.Empty;
			string strComma = string.Empty;

			//Check Pooling
			BOL.BloodUnitModification bumEdit = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);

			System.Guid poolGuid = this.CreatePoolForTests(false, true);
			bumEdit.EditPool(poolGuid);

			foreach(BOL.BloodUnit bu in bumEdit.PoolingUnits)
			{
				checkValue += strComma + bu.BloodProductGuid.ToString();
				strComma = ",";
			}
			Assert.AreEqual(checkValue, bumEdit.GetBloodProductGuidArray(), "Pooled");

			//Check Split
			BOL.BloodUnitModification bumSplit = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
			bumSplit.SplitUnit(this._splitGuid,2);
			Assert.AreEqual(bumSplit.SplittingUnit.BloodProductGuid.ToString(), bumSplit.GetBloodProductGuidArray(), "Split");

			//Check all other Mods
			BOL.BloodUnitModification bumThaw = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			bumThaw.ModifyUnit(this._thawGuid);
			Assert.AreEqual(bumThaw.OriginalUnit.BloodProductGuid.ToString(), bumThaw.GetBloodProductGuidArray(), "Modify");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodProductGuidArray_Fail()
		{
		}

		[Test]
		public void GetExpirationDateRule_Pass()
		{
			//Create the pool to work with ------
			System.Guid tmpGuid = System.Guid.NewGuid();
			System.Guid poolGuid = this.CreatePoolForTests(true, true);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.AddUnitToPool(this._pooledUnitA);
			tstBUM.AddUnitToPool(this._pooledUnitB);

			if (tstBUM.PoolingUnits.Count < 2)
				Assert.IsTrue(false, "Powerful weak!  Pool not created.");

			tstBUM.PoolUnits(this.MyLockController);

			int openRule = 0;
			int closedRule = 0;

			DataTable dtRules = DAL.BloodProduct.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray(), Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Pooled), Common.ModifyUnitMethod.None);
			if (dtRules.Rows.Count > 0)		//If no rows found, leave zeroes
			{
				DataRow[] drOpen = dtRules.Select("MethodSelect = 1");
				if (drOpen.Length > 0)
				{
					openRule = (int)drOpen[0][Common.VbecsTables.PermittedProductModification.ExpirationDateRule];
				}
			}

			int retValue = openRule;
			Assert.AreEqual(true, retValue > 0, "Non-Zero");

			//Now we're going to create a situation, where we try to modify a unit that we know has no target products ---
			System.Guid unitGuid = System.Guid.NewGuid();
			System.Guid bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE ProductCodeIndicator = 0 AND ProductTypeCode = 'E004'");
			DataCreator.CreateBloodUnit(unitGuid, System.Guid.NewGuid(), System.Guid.Empty, bpGuid, true);

			tstBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			tstBUM.SplitUnit(unitGuid, 2);

			dtRules = DAL.BloodProduct.GetTargetBloodProducts(tstBUM.GetBloodProductGuidArray(), Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.SplitAdult), Common.ModifyUnitMethod.None);
			if (dtRules.Rows.Count > 0)		//If no rows found, leave zeroes
			{
				DataRow[] drClosed = dtRules.Select("MethodSelect = 0");
				if (drClosed.Length > 0)
				{
					closedRule = (int)drClosed[0][Common.VbecsTables.PermittedProductModification.ExpirationDateRule];
				}
			}

			retValue = closedRule;

			Assert.AreEqual(0, retValue, "Zero");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetExpirationDateRule_Fail()
		{
		}


		private decimal GetModificationCost(Common.ProductModification modType, int splitCount, decimal modCost)
		{
			decimal childUnits = splitCount;
				
			//Calculate the cost for the actual Modification -- a defined in UC_9
			decimal childModificationCost = decimal.Divide(modCost, childUnits);

			childModificationCost = decimal.Round(childModificationCost, 2);
			if (childModificationCost * childUnits < modCost)
				childModificationCost += (decimal).01;

			return(childModificationCost);
		}

		[Test]
		public void WorkloadCode_Pass()
		{
			BOL.BloodUnitModification tmpBUM;

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.DeglycerolizeUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Deglycerolized, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.DeglycerolizeUnit, tmpBUM.WorkloadCode, "Deglycerolized");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.PoolUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.EditPool, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.PoolUnit, tmpBUM.WorkloadCode, "EditPool");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.FreezeUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Frozen, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.FreezeUnit, tmpBUM.WorkloadCode, "Frozen");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.IrradiateUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Irradiated, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.IrradiateUnit, tmpBUM.WorkloadCode, "Irradiated");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LeukoreduceUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.LeukoReduced, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.LeukoreduceUnit, tmpBUM.WorkloadCode, "LeukoReduced");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.PoolUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.PoolUnit, tmpBUM.WorkloadCode, "Pooled");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ThawPoolCryo);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.PoolThawCryo, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.ThawPoolCryo, tmpBUM.WorkloadCode, "PoolThawCryo");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.RejuvenateUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Rejuvenated, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.RejuvenateUnit, tmpBUM.WorkloadCode, "Rejuvenated");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.SplitUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.SplitUnit, tmpBUM.WorkloadCode, "SplitAdult");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.Thaw);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.Thaw, tmpBUM.WorkloadCode, "Thawed");

			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Unknown, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.Unknown, tmpBUM.WorkloadCode, "Unknown");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.VolumeReduce);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.VolumeReduce, tmpBUM.WorkloadCode, "VolumeReduced");

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.WashUnit);
			tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.Washed, Common.ModifyUnitMethod.Closed, System.DateTime.Now, Common.LogonUser.LogonUserName);
			Assert.AreEqual(Common.WorkloadProcessID.WashUnit, tmpBUM.WorkloadCode, "Washed");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WorkloadCode_Fail()
		{
		}

		#region Data Setup
		/// <summary>
		/// Calculates the probability of me buying new shoes after work today
		/// </summary>
		/// <returns></returns>
		public System.Guid CreatePoolForTests(bool onlyCreatePoolableUnits, bool isCodabar)
		{
			System.Collections.ArrayList tstSupplies = new System.Collections.ArrayList();
			System.Collections.ArrayList tstEquipment = new System.Collections.ArrayList();

			System.DateTime modificationTime = System.DateTime.Now;

			this.CreateSuppliesAndEquipment();

			tstSupplies.Add(this._supply);
			tstSupplies.Add(this._supply2);
			tstEquipment.Add(this._equipment);
			tstEquipment.Add(this._equipment2);

			//Get the BloodProductGuid that we CAN pool without problems....hopefully -- these harcoded values may have to change with TT changes
			System.Guid poolableBPGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE ProductCode = 'E3841' AND ProductTypeCode = 'E020'");

			System.Guid unit1Guid = System.Guid.NewGuid();
			System.Guid unit2Guid = System.Guid.NewGuid();

			//Create the 2 units to add to our pool
			DataCreator.CreateBloodUnit(unit1Guid, System.Guid.NewGuid(), System.Guid.Empty, poolableBPGuid, isCodabar);
			DataCreator.CreateBloodUnit(unit2Guid, System.Guid.NewGuid(), System.Guid.Empty, poolableBPGuid, isCodabar);

			//Grab the 2 units we just created
			this._pooledUnitA = new BOL.BloodUnit(unit1Guid);
			this._pooledUnitB = new BOL.BloodUnit(unit2Guid);

			if (onlyCreatePoolableUnits)
			{
				this._dtPool = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, false);	
				return(System.Guid.Empty);
			}

			//Add the 2 units to the pool
			BOL.BloodUnitModification poolBUM = new BOL.BloodUnitModification(Common.ProductModification.Pooled, Common.ModifyUnitMethod.Open, modificationTime, Common.LogonUser.LogonUserName);
			poolBUM.AddUnitToPool(this._pooledUnitA);
			poolBUM.AddUnitToPool(this._pooledUnitB);
			poolBUM.PoolUnits(this.MyLockController);
            this.MyLockController.UnlockRecords();

			poolBUM.PooledUnit.Container = this._container;
			poolBUM.PooledUnit.SCDWafer = this._scdWafer;
			poolBUM.PooledUnit.SupplyList = tstSupplies;
			poolBUM.PooledUnit.EquipmentList = tstEquipment;

			//Get the target bloodproduct
			DataTable dtTargets = poolBUM.GetTargetBloodProducts(poolBUM.GetBloodProductGuidArray());
			if (dtTargets.Rows.Count == 0)
				Assert.AreEqual("No target units to create pool -- CreatePoolForTests()", false);

			poolBUM.PooledUnit.TargetBloodProduct = new BOL.BloodProduct(dtTargets.Rows[0]);

			//we're going to create ProductShipper(if not one already)
			BOL.Division tmpDiv = new BOL.Division(UnitTestConfig.TestDivisionCode);
			BOL.LocalSupplier tmpLS = new BOL.LocalSupplier(tmpDiv.LocalSupplierGuid, false);
			BOL.ProductShipper tmpPS = poolBUM.PooledUnit.TargetBloodProduct.ProductShippers.GetElementByLocalSupplierGuid(tmpLS.LocalSupplierGuid);
			if (tmpPS == null)
			{
				tmpPS = new BOL.ProductShipper(System.Guid.NewGuid(), poolBUM.PooledUnit.TargetBloodProduct.BloodProductGuid);
				tmpPS.ProductCost = 1;
				tmpPS.LocalSupplierGuid = tmpLS.LocalSupplierGuid;
				tmpPS.ReturnCreditPercentage = 1;
				tmpPS.RecordStatusCode = Common.RecordStatusCode.Active;
				poolBUM.PooledUnit.TargetBloodProduct.HcpcsCode = "P2031";		//fix someday, even tho theres no RI
				poolBUM.PooledUnit.TargetBloodProduct.ProductShippers.Add(tmpPS);
				poolBUM.PooledUnit.TargetBloodProduct.Save(Common.UpdateFunction.UnitTests);
			}

			//Save the pool and all it's glory to the database
			if (this.DoesPoolViolateCheckContraint(poolBUM))	
				poolBUM.PooledUnit.NewUnit.SetEyeReadableUnitId(System.DateTime.Now.ToString("yyMMddHHmmss"), false);

			if (!poolBUM.Save(Common.UpdateFunction.UnitTests))
				Assert.IsTrue(false, "Pool Creation Fail -- CreatePoolForTests()");

			return(poolBUM.PooledUnit.NewUnit.BloodUnitGuid);
		}

		/// <summary>
		/// Flurking Shnit!
		/// </summary>
		private void CreateSuppliesAndEquipment()
		{
			if (this._supply != null) return;

			System.Collections.ArrayList tstSupplies = new System.Collections.ArrayList();
			System.Collections.ArrayList tstEquipment = new System.Collections.ArrayList();

			//Create a NEW CONTAINER!!!
			this._container = new BOL.Supply(System.Guid.NewGuid());
			this._container.LotQuantity = 500;
			this._container.AvailableQuantity = 100;
			this._container.DivisionCode = this.TestDivisionCode;
			this._container.InvoiceNumber = new Random().Next(11111,999999).ToString();
			this._container.LotExpirationDate = System.DateTime.Now.AddYears(1);
			this._container.LotNumber = new Random().Next(11111,99999).ToString();
			this._container.ManufacturerName = "Wendy's Discount Blood Supplies and Burgers";
			this._container.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			this._container.ReceiptTechId = Common.LogonUser.LogonUserName;
			this._container.SatisfactoryIndicator = true;
			this._container.SupplyName = "Sterile Shoe";
			this._container.SupplyTypeId = (int)Common.SupplyType.Containers;
			tstSupplies.Add(this._container);

			//Create a NEW SUPPLY 
			this._supply = new BOL.Supply(System.Guid.NewGuid());
			this._supply.LotQuantity = 500;
			this._supply.AvailableQuantity = 100;
			this._supply.DivisionCode = this.TestDivisionCode;
			this._supply.InvoiceNumber = new Random().Next(11111,999999).ToString();
			this._supply.LotExpirationDate = System.DateTime.Now.AddYears(1);
			this._supply.LotNumber = new Random().Next(11111,99999).ToString();
			this._supply.ManufacturerName = "Wendy's Discount Blood Supplies and Burgers";
			this._supply.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			this._supply.ReceiptTechId = Common.LogonUser.LogonUserName;
			this._supply.SatisfactoryIndicator = true;
			this._supply.SupplyName = "Rawhide Proctological Gloves";
			this._supply.SupplyTypeId = (int)Common.SupplyType.Gloves;
			tstSupplies.Add(this._supply);

			//Create a 2nd supply
			this._supply2 = new BOL.Supply(System.Guid.NewGuid());
			this._supply2.LotQuantity = 500;
			this._supply2.AvailableQuantity = 100;
			this._supply2.DivisionCode = this.TestDivisionCode;
			this._supply2.InvoiceNumber = new Random().Next(11111,999999).ToString();
			this._supply2.LotExpirationDate = System.DateTime.Now.AddYears(1);
			this._supply2.LotNumber = new Random().Next(11111,99999).ToString();
			this._supply2.ManufacturerName = "Grimey's Supply House";
			this._supply2.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			this._supply2.ReceiptTechId = Common.LogonUser.LogonUserName;
			this._supply2.SatisfactoryIndicator = true;
			this._supply2.SupplyName = "Lubricated Cotton Swabs";
			this._supply2.SupplyTypeId = (int)Common.SupplyType.OtherEach;
			tstSupplies.Add(this._supply2);

			//Create a NEW SCDWAFER 
			this._scdWafer = new BOL.Supply(System.Guid.NewGuid());
			this._scdWafer.LotQuantity = 500;
			this._scdWafer.AvailableQuantity = 100;
			this._scdWafer.DivisionCode = this.TestDivisionCode;
			this._scdWafer.InvoiceNumber = new Random().Next(11111,999999).ToString();
			this._scdWafer.LotExpirationDate = System.DateTime.Now.AddYears(1);
			this._scdWafer.LotNumber = new Random().Next(11111,99999).ToString();
			this._scdWafer.ManufacturerName = "Wendy's Discount Blood Supplies and Burgers";
			this._scdWafer.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			this._scdWafer.ReceiptTechId = Common.LogonUser.LogonUserName;
			this._scdWafer.SatisfactoryIndicator = true;
			this._scdWafer.SupplyName = "Mmmmmmm Wafer";
			this._scdWafer.SupplyTypeId = (int)Common.SupplyType.SCDWafer;
			tstSupplies.Add(this._scdWafer);

			if (!BOL.Supply.InsertSupplies(tstSupplies, Common.UpdateFunction.UnitTests))
				Assert.IsTrue(false, "Supplies creation failed.. Supply Insert bombed! -- CreateSuppliesAndEquipment()");

			//Create a NEW EQUIPMENT!!
			this._equipment = new BOL.Equipment(System.Guid.NewGuid());
			this._equipment.DivisionCode = this.TestDivisionCode;
			this._equipment.EquipmentName = "Ostrich Egg";
			this._equipment.EquipmentType = "Snack";
			this._equipment.InspectionIndicator = true;
			this._equipment.InvoiceNumber = new Random().Next(11111,99999).ToString();
			this._equipment.IsMaintenanceContractDate = false;
			this._equipment.LocalIdentifier = "Meh-" + new Random().Next(111,999).ToString();
			this._equipment.ManufacturerName = "HJS Enterprizes";
			this._equipment.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			this._equipment.ReceiptTechId = Common.LogonUser.LogonUserName;
			this._equipment.SerialNumber = new Random().Next(111111,999999).ToString();
			tstEquipment.Add(this._equipment);
			
			//Create a 2nd Equipment
			this._equipment2 = new BOL.Equipment(System.Guid.NewGuid());
			this._equipment2.DivisionCode = this.TestDivisionCode;
			this._equipment2.EquipmentName = "    wood Stabbing Stick";
			this._equipment2.EquipmentType = "Tool";
			this._equipment2.InspectionIndicator = true;
			this._equipment2.InvoiceNumber = new Random().Next(11111,99999).ToString();
			this._equipment2.IsMaintenanceContractDate = false;
			this._equipment2.LocalIdentifier = "Doh-" + new Random().Next(111,999).ToString();
			this._equipment2.ManufacturerName = "Indy Inc";
			this._equipment2.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			this._equipment2.ReceiptTechId = Common.LogonUser.LogonUserName;
			this._equipment2.SerialNumber = new Random().Next(111111,999999).ToString();
			tstEquipment.Add(this._equipment2);

			if (!BOL.Equipment.InsertEquipment(tstEquipment, Common.UpdateFunction.UnitTests))
				Assert.IsTrue(false, "Equipment creation failed.. Equipment Insert bombed! -- CreateSuppliesAndEquipment()");

		}



		private bool DoesPoolViolateCheckContraint(BOL.BloodUnitModification tstBUM)
		{
			string labelUnitId = tstBUM.PooledUnit.NewUnit.LabelUnitId;
			string eyeReadableId = tstBUM.PooledUnit.NewUnit.EyeReadableUnitId;
			string bpGuid = tstBUM.PooledUnit.TargetBloodProduct.BloodProductGuid.ToString();
			string unitDivisionId = tstBUM.PooledUnit.NewUnit.UnitDivisionId;
			string division = this.TestDivisionCode;
			string donationTypeId = tstBUM.PooledUnit.NewUnit.DonationType.DonationTypeId.ToString();
			string unitFdaNum = tstBUM.PooledUnit.NewUnit.UnitFdaRegistrationNumber;
			string bloodUnitGuid = tstBUM.PooledUnit.NewUnit.BloodUnitGuid.ToString();

			DataRow drOutput = UnitTestUtil.RunSQLGetDataRow("SELECT dbo.fnBloodUnitLogicalKey('" + division + "', '" + labelUnitId + "','" + eyeReadableId + "','" + bpGuid + "','" + donationTypeId + "','" + unitFdaNum + "','" + bloodUnitGuid + "')");
			return(System.Convert.ToInt16(drOutput[0]) > 0);
		}
		#endregion
        

	}
}
#endif



